/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ServerMessageHandler;
import org.eclipse.lsp4e.command.CommandExecutor;
import org.eclipse.lsp4e.operations.codeactions.CodeActionCompletionProposal;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class CodeActionMarkerResolution
extends WorkbenchMarkerResolution
implements IMarkerResolution {
    private CodeAction codeAction;

    public CodeActionMarkerResolution(CodeAction codeAction) {
        this.codeAction = codeAction;
    }

    public CodeAction getCodeAction() {
        return this.codeAction;
    }

    public String getDescription() {
        return this.codeAction.getTitle();
    }

    public @Nullable Image getImage() {
        return null;
    }

    public String getLabel() {
        return this.codeAction.getTitle();
    }

    public void run(IMarker marker) {
        if (this.codeAction.getEdit() != null) {
            LSPEclipseUtils.applyWorkspaceEdit(this.codeAction.getEdit(), this.codeAction.getTitle());
            return;
        }
        LanguageServerWrapper wrapper = this.getLanguageServerWrapper(marker);
        if (wrapper != null) {
            this.resolveCodeAction(wrapper);
            if (this.codeAction.getEdit() != null) {
                LSPEclipseUtils.applyWorkspaceEdit(this.codeAction.getEdit(), this.codeAction.getTitle());
            }
            if (this.codeAction.getCommand() != null) {
                ExecuteCommandOptions provider;
                Command command = this.codeAction.getCommand();
                ServerCapabilities cap = wrapper.getServerCapabilities();
                ExecuteCommandOptions executeCommandOptions = provider = cap == null ? null : cap.getExecuteCommandProvider();
                if (provider != null && provider.getCommands().contains(command.getCommand())) {
                    LanguageServersRegistry.LanguageServerDefinition serverDefinition = wrapper.serverDefinition;
                    wrapper.execute(ls -> ls.getWorkspaceService().executeCommand(new ExecuteCommandParams(command.getCommand(), command.getArguments())).exceptionally(t -> this.reportServerError(serverDefinition, (Throwable)t)));
                } else {
                    IResource resource = marker.getResource();
                    if (resource != null) {
                        CommandExecutor.executeCommandClientSide(command, resource);
                    }
                }
            }
        }
    }

    private ShowMessageRequestParams reportServerError(LanguageServersRegistry.LanguageServerDefinition serverDefinition, Throwable t) {
        ShowMessageRequestParams params = new ShowMessageRequestParams();
        String title = "Error Executing Quick Fix";
        params.setType(MessageType.Error);
        params.setMessage("Failed to fetch quick fix edit for '" + this.codeAction.getTitle() + "'. See Language Server '" + serverDefinition.id + "' log for more details.");
        ServerMessageHandler.showMessage("Error Executing Quick Fix", (MessageParams)params);
        return params;
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return (IMarker[])Arrays.stream(markers).filter(marker -> {
            try {
                return this.codeAction.getDiagnostics().contains(marker.getAttribute("lspDiagnostic"));
            }
            catch (CoreException e) {
                LanguageServerPlugin.logError(e);
                return false;
            }
        }).toArray(IMarker[]::new);
    }

    public @Nullable LanguageServerWrapper getLanguageServerWrapper(IMarker marker) {
        IResource resource;
        String languageServerId = marker.getAttribute("languageServerId", null);
        LanguageServersRegistry.LanguageServerDefinition definition = languageServerId != null ? LanguageServersRegistry.getInstance().getDefinition(languageServerId) : null;
        LanguageServerWrapper wrapper = null;
        if (definition != null && (resource = marker.getResource()) != null) {
            wrapper = LanguageServiceAccessor.getLSWrapper(resource.getProject(), definition);
        }
        return wrapper;
    }

    public void resolveCodeAction(LanguageServerWrapper wrapper) {
        if (this.codeAction.getEdit() != null) {
            return;
        }
        if (CodeActionCompletionProposal.isCodeActionResolveSupported(wrapper.getServerCapabilities())) {
            try {
                CodeAction resolvedCodeAction = (CodeAction)wrapper.execute(ls -> ls.getTextDocumentService().resolveCodeAction(this.codeAction)).get(2L, TimeUnit.SECONDS);
                if (resolvedCodeAction != null) {
                    this.codeAction = resolvedCodeAction;
                }
            }
            catch (TimeoutException e) {
                LanguageServerPlugin.logWarning("Could not resolve code actions due to timeout after 2 seconds in `textDocument/resolveCodeAction`");
            }
            catch (ExecutionException e) {
                LanguageServerPlugin.logError(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LanguageServerPlugin.logError(e);
            }
        }
    }
}

