/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import jakarta.inject.Inject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.testing.ContributionInfoMessages;
import org.eclipse.ui.part.AbstractMultiEditor;
import org.eclipse.ui.part.MultiEditor;
import org.eclipse.ui.part.MultiEditorInput;
import org.eclipse.ui.testing.ContributionInfo;

public class CompatibilityEditor
extends CompatibilityPart {
    public static final String MODEL_ELEMENT_ID = "org.eclipse.e4.ui.compatibility.editor";
    private final EditorReference reference;
    @Inject
    private EModelService modelService;

    @Inject
    CompatibilityEditor(MPart part, EditorReference ref) {
        super(part);
        this.reference = ref;
    }

    @Override
    IWorkbenchPart createPart(WorkbenchPartReference reference) throws PartInitException {
        IEditorInput input;
        IWorkbenchPart part = super.createPart(reference);
        if (part instanceof MultiEditor && (input = ((EditorReference)reference).getEditorInput()) instanceof MultiEditorInput) {
            this.createMultiEditorChildren(part, input);
        }
        return part;
    }

    private void createMultiEditorChildren(IWorkbenchPart part, IEditorInput input) throws PartInitException {
        IWorkbenchPage page = this.reference.getPage();
        MPart model = this.getModel();
        MWindow window = this.modelService.getTopLevelWindowFor((MUIElement)model);
        IEditorRegistry registry = (IEditorRegistry)model.getContext().get(IEditorRegistry.class);
        MultiEditorInput multiEditorInput = (MultiEditorInput)input;
        IEditorInput[] inputs = multiEditorInput.getInput();
        String[] editorIds = multiEditorInput.getEditors();
        IEditorPart[] editors = new IEditorPart[editorIds.length];
        int i = 0;
        while (i < editorIds.length) {
            EditorDescriptor innerDesc = (EditorDescriptor)registry.findEditor(editorIds[i]);
            if (innerDesc == null) {
                throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_unknownEditorIDMessage, (Object)editorIds[i]));
            }
            EditorReference innerReference = new EditorReference(window.getContext(), page, model, inputs[i], innerDesc, null);
            editors[i] = (IEditorPart)innerReference.createPart();
            innerReference.initialize(editors[i]);
            ++i;
        }
        ((AbstractMultiEditor)part).setChildren(editors);
    }

    @Override
    protected boolean createPartControl(IWorkbenchPart legacyPart, Composite parent) {
        super.createPartControl(legacyPart, parent);
        this.clearMenuItems();
        this.part.getContext().set(IEditorPart.class, (Object)((IEditorPart)legacyPart));
        EditorDescriptor descriptor = this.reference.getDescriptor();
        if (descriptor != null) {
            IConfigurationElement element = descriptor.getConfigurationElement();
            if (element != null) {
                String iconURI = MenuHelper.getIconURI(element, "icon");
                this.part.setIconURI(iconURI);
            }
            if (descriptor.getPluginId() != null) {
                parent.setData((Object)new ContributionInfo(descriptor.getPluginId(), ContributionInfoMessages.ContributionInfo_Editor, null));
            }
        }
        if (legacyPart instanceof AbstractMultiEditor && !(legacyPart instanceof MultiEditor)) {
            try {
                this.createMultiEditorChildren(legacyPart, this.reference.getEditorInput());
            }
            catch (PartInitException e) {
                this.handlePartInitException(e);
                return false;
            }
        }
        return true;
    }

    public IEditorPart getEditor() {
        return (IEditorPart)this.getPart();
    }

    @Override
    public WorkbenchPartReference getReference() {
        return this.reference;
    }

    @Override
    void disposeSite(PartSite site) {
        EditorActionBars bars = (EditorActionBars)site.getActionBars();
        EditorReference.disposeEditorActionBars(bars);
        super.disposeSite(site);
    }
}

