/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IRegistry;
import org.eclipse.linuxtools.internal.docker.core.DockerImage;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImagePushPage;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;

public class ImagePush
extends Wizard {
    private ImagePushPage mainPage;
    private final IDockerImage image;
    private final String defaultImageName;

    public ImagePush(IDockerImage image, String defautImageName) {
        this.setWindowTitle(WizardMessages.getString("ImagePush.name"));
        this.image = image;
        this.defaultImageName = defautImageName;
    }

    public IDockerImage getImage() {
        return this.image;
    }

    public String getDefaultImageName() {
        return this.defaultImageName;
    }

    public String getSelectedImageTag() {
        String selectedImageName = this.mainPage.getSelectedImageName();
        return DockerImage.setDefaultTagIfMissing((String)selectedImageName);
    }

    public IRegistry getRegistry() {
        return this.mainPage.getSelectedRegistryAccount();
    }

    public boolean isForceTagging() {
        return this.mainPage.isForceTagging();
    }

    public boolean isKeepTaggedImage() {
        return this.mainPage.isKeepTaggedImage();
    }

    public void addPages() {
        this.mainPage = new ImagePushPage(this.image, this.defaultImageName);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean canFinish() {
        return this.mainPage.isPageComplete();
    }

    public boolean performFinish() {
        return true;
    }
}

