/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.commands;

import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataWriteMemoryInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class MIDataWriteMemory
extends MICommand<MIDataWriteMemoryInfo> {
    public MIDataWriteMemory(IDMContext ctx, long offset, String address, int wordFormat, int wordSize, String value) {
        super(ctx, "-data-write-memory");
        if (offset != 0L) {
            this.setOptions(new String[]{"-o", Long.toString(offset)});
        }
        String format = "x";
        switch (wordFormat) {
            case 15: {
                format = "u";
                break;
            }
            case 10: {
                format = "f";
                break;
            }
            case 11: {
                format = "a";
                break;
            }
            case 12: {
                format = "i";
                break;
            }
            case 13: {
                format = "c";
                break;
            }
            case 14: {
                format = "s";
                break;
            }
            case 3: 
            case 5: {
                format = "d";
                break;
            }
            case 2: {
                format = "t";
                break;
            }
            case 1: {
                format = "o";
                break;
            }
            default: {
                format = "x";
            }
        }
        this.setParameters(new String[]{address, format, Integer.toString(wordSize), value});
    }

    @Override
    public MIDataWriteMemoryInfo getResult(MIOutput out) {
        return new MIDataWriteMemoryInfo(out);
    }
}

