/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.events;

import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

@Immutable
public class MIWatchpointScopeEvent
extends MIStoppedEvent {
    private final String number;

    protected MIWatchpointScopeEvent(IRunControl.IExecutionDMContext ctx, int token, MIResult[] results, MIFrame frame, String number) {
        super(ctx, token, results, frame);
        this.number = number;
    }

    public String getNumber() {
        return this.number;
    }

    public static MIWatchpointScopeEvent parse(IRunControl.IExecutionDMContext dmc, int token, MIResult[] results) {
        String number = "";
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            if (var.equals("wpnum") && value instanceof MIConst) {
                String str = ((MIConst)value).getString();
                try {
                    number = str.trim();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        MIStoppedEvent stoppedEvent = MIStoppedEvent.parse(dmc, token, results);
        return new MIWatchpointScopeEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), number);
    }
}

