/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakpoint;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class CLICatchInfo
extends MIInfo {
    private MIBreakpoint fMiBreakpoint;

    public CLICatchInfo(MIOutput record) {
        super(record);
        assert (record != null);
        this.parse();
    }

    protected void parse() {
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] mIOOBRecordArray = out.getMIOOBRecords();
            int n = mIOOBRecordArray.length;
            int n2 = 0;
            while (n2 < n) {
                MIOOBRecord oob = mIOOBRecordArray[n2];
                if (oob instanceof MIConsoleStreamOutput) {
                    this.fMiBreakpoint = this.parseCatchpoint(((MIConsoleStreamOutput)oob).getString().trim());
                    if (this.fMiBreakpoint != null) {
                        return;
                    }
                }
                ++n2;
            }
        }
    }

    private MIBreakpoint parseCatchpoint(String str) {
        return str.startsWith("Catchpoint ") ? this.createMIBreakpoint(str) : null;
    }

    protected MIBreakpoint createMIBreakpoint(String str) {
        return new MIBreakpoint(str);
    }

    public MIBreakpoint getMIBreakpoint() {
        return this.fMiBreakpoint;
    }
}

