/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.concurrent;

import org.eclipse.cdt.dsf.concurrent.AbstractCache;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateInDsfExecutor;
import org.eclipse.core.runtime.IStatus;

@ConfinedToDsfExecutor(value="fExecutor")
public abstract class RequestCache<V>
extends AbstractCache<V> {
    protected DataRequestMonitor<V> fRm;

    public RequestCache(ImmediateInDsfExecutor executor) {
        super(executor);
    }

    @Override
    protected final void retrieve() {
        if (this.fRm != null) {
            this.fRm.cancel();
        }
        this.fRm = new DataRequestMonitor<V>(this.getImmediateInDsfExecutor(), null){

            @Override
            protected void handleCompleted() {
                if (this == RequestCache.this.fRm) {
                    RequestCache.this.fRm = null;
                    if (!this.isCanceled()) {
                        RequestCache.this.set(this.getData(), this.getStatus());
                    }
                }
            }

            @Override
            public boolean isCanceled() {
                return super.isCanceled() || RequestCache.this.isCanceled();
            }
        };
        this.retrieve(this.fRm);
    }

    protected abstract void retrieve(DataRequestMonitor<V> var1);

    @Override
    protected synchronized void canceled() {
        if (this.fRm != null) {
            this.fRm.cancel();
        }
    }

    @Override
    protected void set(V data, IStatus status) {
        if (this.fRm != null) {
            this.fRm.cancel();
            this.fRm = null;
        }
        super.set(data, status);
    }

    @Override
    protected void reset() {
        if (this.fRm != null) {
            this.fRm.cancel();
            this.fRm = null;
        }
        super.reset();
    }
}

