/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.serial;

import java.util.Arrays;
import java.util.Optional;

@Deprecated
public enum BaudRate {
    B110,
    B300,
    B600,
    B1200,
    B2400,
    B4800,
    B9600,
    B14400,
    B19200,
    B38400,
    B57600,
    B115200,
    B230400,
    B460800,
    B500000,
    B576000,
    B921600,
    B1000000,
    B1152000,
    B1500000,
    B2000000,
    B2500000,
    B3000000,
    B3500000,
    B4000000;

    private final int rate = Integer.parseInt(this.toString().substring(1));

    public int getRate() {
        return this.rate;
    }

    private String getSpeedString() {
        return this.toString().substring(1);
    }

    public static String[] getStrings() {
        return (String[])Arrays.asList(BaudRate.values()).stream().map(BaudRate::getSpeedString).toArray(String[]::new);
    }

    public static BaudRate fromStringIndex(int rate) {
        if (rate < BaudRate.values().length && rate >= 0) {
            return BaudRate.values()[rate];
        }
        return BaudRate.getDefault();
    }

    public static int getStringIndex(BaudRate rate) {
        return rate.ordinal();
    }

    public static BaudRate getClosest(int baudRate) {
        Optional reduce = Arrays.asList(BaudRate.values()).stream().reduce((result, current) -> {
            if (Math.abs(baudRate - current.getRate()) < Math.abs(baudRate - result.getRate())) {
                return current;
            }
            return result;
        });
        return (BaudRate)((Object)reduce.get());
    }

    public static BaudRate getDefault() {
        return B115200;
    }
}

