/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.participants;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.IConditionChecker;
import org.eclipse.ltk.core.refactoring.resource.Resources;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;

public class ValidateEditChecker
implements IConditionChecker {
    private final Set<IFile> fFiles = new HashSet<IFile>();
    private final Object fContext;

    public ValidateEditChecker(Object context) {
        this.fContext = context;
    }

    public void addFile(IFile file) {
        Assert.isNotNull((Object)file);
        this.fFiles.add(file);
    }

    public void addFiles(IFile[] files) {
        Assert.isNotNull((Object)files);
        this.fFiles.addAll(Arrays.asList(files));
    }

    @Override
    public RefactoringStatus check(IProgressMonitor monitor) throws CoreException {
        IResource[] resources = this.fFiles.toArray(new IResource[this.fFiles.size()]);
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync(resources);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create(status));
        }
        if (!(status = Resources.makeCommittable(resources, this.fContext)).isOK()) {
            result.merge(RefactoringStatus.create(status));
            if (!result.hasFatalError()) {
                result.addFatalError(RefactoringCoreMessages.ValidateEditChecker_failed);
            }
        }
        return result;
    }
}

