/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.markers;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.tracecompass.internal.tmf.core.markers.Marker;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSegment;

public abstract class SubMarker
extends Marker {
    private SubMarker(String name, String color) {
        super(name, color);
    }

    public static class SplitMarker
    extends SubMarker {
        private final String fLabel;
        private final String fId;
        private final Range<Long> fRange;
        private final RangeSet<Long> fIndexRange;

        public SplitMarker(String name, String label, String id, String color, Range<Long> range, RangeSet<Long> indexRange) {
            super(name, color);
            this.fLabel = label;
            this.fId = id;
            this.fRange = range;
            this.fIndexRange = indexRange;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public String getId() {
            return this.fId;
        }

        public Range<Long> getRange() {
            return this.fRange;
        }

        public RangeSet<Long> getIndexRange() {
            return this.fIndexRange;
        }
    }

    public static class WeightedMarker
    extends SubMarker {
        private final List<MarkerSegment> fSegments = new ArrayList<MarkerSegment>();
        private long fTotalLength = 0L;

        public WeightedMarker(String name) {
            super(name, null);
        }

        public List<MarkerSegment> getSegments() {
            return this.fSegments;
        }

        public void addSegment(MarkerSegment segment) {
            this.fSegments.add(segment);
            this.fTotalLength += (long)segment.getLength();
        }

        public long getTotalLength() {
            return this.fTotalLength;
        }
    }
}

