/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.filters;

import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.Activator;

public class TimeQueryFilter {
    private long @Nullable [] fTimesRequested;
    private long fStart;
    private long fEnd;
    private int fNbSamples;

    public TimeQueryFilter(long start, long end, int n) {
        this.fStart = start;
        this.fEnd = end;
        this.fNbSamples = n;
    }

    public TimeQueryFilter(List<Long> times) {
        if (times.isEmpty()) {
            throw new IllegalArgumentException("The requested times is empty");
        }
        if (!Ordering.natural().isOrdered(times)) {
            throw new IllegalArgumentException("List of times is not sorted");
        }
        this.fTimesRequested = Longs.toArray(times);
    }

    public long[] getTimesRequested() {
        if (this.fTimesRequested == null) {
            this.fTimesRequested = TimeQueryFilter.splitRangeIntoEqualParts(this.fStart, this.fEnd, this.fNbSamples);
        }
        return Objects.requireNonNull(this.fTimesRequested);
    }

    public long getStart() {
        if (this.fTimesRequested != null) {
            return this.fTimesRequested[0];
        }
        return this.fStart;
    }

    public long getEnd() {
        if (this.fTimesRequested != null) {
            return this.fTimesRequested[Integer.max(0, Objects.requireNonNull(this.fTimesRequested).length - 1)];
        }
        return this.fEnd;
    }

    public int getNumberOfSamples() {
        if (this.fTimesRequested != null) {
            return Objects.requireNonNull(this.fTimesRequested).length;
        }
        return this.fNbSamples;
    }

    private static final long[] splitRangeIntoEqualParts(long start, long end, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of entries must be greater than 0");
        }
        if (n == 1) {
            if (start == end) {
                long[] result = new long[]{start};
                return result;
            }
            throw new IllegalArgumentException("Number of entries requested is 1, but start and end are different. Impossible to create array.");
        }
        if (n > 65536) {
            Activator.logWarning(String.format("Number of entries is very large, it is likely a bug and will result in slower queries. start time = %d, end time = %d, number of elements = %d", start, end, n));
        }
        double stepSize = (double)Math.abs(end - start) / ((double)n - 1.0);
        long[] result = new long[n];
        int i = 0;
        while (i < n) {
            result[i] = Math.min(start, end) + Math.round((double)i * stepSize);
            ++i;
        }
        result[result.length - 1] = Math.max(start, end);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        TimeQueryFilter other = (TimeQueryFilter)obj;
        return Arrays.equals(this.fTimesRequested, other.getTimesRequested());
    }

    public int hashCode() {
        return Arrays.hashCode(this.fTimesRequested);
    }
}

