/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.core.jobs;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.internal.packs.core.Activator;
import org.eclipse.embedcdt.packs.core.IConsoleStream;
import org.eclipse.embedcdt.packs.core.Utils;
import org.eclipse.embedcdt.packs.core.data.DataUtils;
import org.eclipse.embedcdt.packs.core.data.PacksStorage;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.PackNode;

public class CopyExampleJob
extends Job {
    private static boolean fgRunning = false;
    private String[] fParam;
    private IConsoleStream fOut = Activator.getInstance().getConsoleOutput();
    private List<PackNode> fSelection;
    private IPath fDestFolderPath;
    private IProgressMonitor fMonitor;
    private int fSizeOfPrefixToStrip;

    public CopyExampleJob(String name, List<PackNode> selection, String[] param) {
        super(name);
        this.fSelection = selection;
        this.fParam = param;
        this.fSizeOfPrefixToStrip = 0;
        this.fDestFolderPath = new Path(this.fParam[0]);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status;
        if (fgRunning) {
            return Status.CANCEL_STATUS;
        }
        fgRunning = true;
        this.fMonitor = monitor;
        long beginTime = System.currentTimeMillis();
        this.fOut.println();
        this.fOut.println(Utils.getCurrentDateTime());
        int exampleCount = 0;
        for (PackNode exampleNode : this.fSelection) {
            if (monitor.isCanceled()) break;
            PackNode versionNode = (PackNode)exampleNode.getParent();
            Leaf outlineExampleNode = exampleNode.getOutline().findChild("example");
            String packRelativeFolder = versionNode.getProperty("dest.folder");
            String exampleRelativeFolder = outlineExampleNode.getProperty("folder");
            this.fOut.println("Copying example folder \"" + new Path(packRelativeFolder).append(exampleRelativeFolder) + "\"...");
            File destFolder = this.fDestFolderPath.append(exampleRelativeFolder).toFile();
            if (!destFolder.exists() && !destFolder.mkdirs()) {
                this.fOut.println("Cannot create destination folder \"" + destFolder.toString() + "\".");
                return Status.CANCEL_STATUS;
            }
            if (!destFolder.isDirectory()) {
                this.fOut.println("Destination \"" + destFolder.toString() + "\" is not a folder.");
                return Status.CANCEL_STATUS;
            }
            if (destFolder.listFiles().length > 0) {
                this.fOut.println("Destination \"" + destFolder.toString() + "\" is not an empty folder.");
                this.fOut.println("Deleting previous content...");
                int count = DataUtils.deleteFolderRecursive(destFolder);
                this.fOut.println(String.valueOf(count) + " files deleted.");
            }
            try {
                IPath srcFolderPath = PacksStorage.getFolderPath();
                srcFolderPath = srcFolderPath.append(packRelativeFolder);
                this.fSizeOfPrefixToStrip = srcFolderPath.toString().length();
                if (!srcFolderPath.hasTrailingSeparator()) {
                    ++this.fSizeOfPrefixToStrip;
                }
                srcFolderPath = srcFolderPath.append(exampleRelativeFolder);
                int totalWork = (int)this.getFilesSizeRecursive(srcFolderPath.toFile());
                monitor.beginTask("Copy folder", totalWork);
                int count = 0;
                count = this.copyFolderRecursive(srcFolderPath.toFile());
                this.fOut.print("Example \"" + exampleNode.getName() + "\", ");
                this.fOut.print(String.valueOf(StringUtils.convertSizeToString((int)totalWork)) + " in ");
                if (count <= 1) {
                    this.fOut.print("1 file");
                } else {
                    this.fOut.print(String.valueOf(count) + " files");
                }
                this.fOut.println(" copied.");
                ++exampleCount;
            }
            catch (IOException e) {
                this.fOut.print("Error: " + e.toString());
            }
        }
        if (monitor.isCanceled()) {
            this.fOut.println("Job cancelled.");
            status = Status.CANCEL_STATUS;
        } else {
            long endTime = System.currentTimeMillis();
            long duration = endTime - beginTime;
            if (duration == 0L) {
                duration = 1L;
            }
            this.fOut.print("Copy completed in ");
            if (duration < 1000L) {
                this.fOut.print(String.valueOf(duration) + "ms");
            } else {
                this.fOut.print(String.valueOf((duration + 500L) / 1000L) + "s");
            }
            if (exampleCount <= 1) {
                this.fOut.print(" (1 example).");
            } else {
                this.fOut.print(" (" + exampleCount + " examples).");
            }
            this.fOut.println();
            status = Status.OK_STATUS;
        }
        fgRunning = false;
        return status;
    }

    private long getFilesSizeRecursive(File folder) {
        File[] files = folder.listFiles();
        long countBytes = 0L;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                countBytes += this.getFilesSizeRecursive(file);
            } else if (file.isFile()) {
                countBytes += file.length();
            } else {
                Activator.log((String)("File " + file + " unaccounted."));
            }
            ++n2;
        }
        return countBytes;
    }

    private int copyFolderRecursive(File folder) {
        File[] files = folder.listFiles();
        int countFiles = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (this.fMonitor.isCanceled()) break;
            if (file.isDirectory()) {
                countFiles += this.copyFolderRecursive(file);
            } else if (file.isFile()) {
                try {
                    this.copyFile(file);
                }
                catch (IOException e) {
                    this.fOut.print("Error: " + e.toString());
                }
                ++countFiles;
            }
            ++n2;
        }
        return countFiles;
    }

    private void copyFile(File file) throws IOException {
        String path = file.getPath();
        String suffix = path.substring(this.fSizeOfPrefixToStrip);
        IPath destPath = this.fDestFolderPath.append(suffix);
        File destFile = destPath.toFile();
        DataUtils.copyFile(file, destFile, this.fOut, this.fMonitor);
    }
}

