/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.repositories.core.ILocationService;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;
import org.eclipse.mylyn.internal.commons.repositories.core.LocationService;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class TaskRepositorySecureStoreMigrator {
    private final ILocationService service = LocationService.getDefault();

    public void migrateCredentials(Collection<TaskRepository> repositories) {
        if (!SecurePreferencesFactory.getDefault().nodeExists("org.eclipse.mylyn.tasks.core")) {
            return;
        }
        StatusHandler.log((IStatus)new Status(1, "org.eclipse.mylyn.tasks.core", "Migrating task repository credentials from old secure store node."));
        Set<String> repositoryUrls = this.getRepositoryUrls(repositories);
        ISecurePreferences oldRootNode = SecurePreferencesFactory.getDefault().node("org.eclipse.mylyn.tasks.core");
        String[] stringArray = oldRootNode.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            ISecurePreferences repositoryNode = oldRootNode.node(child);
            String repositoryUrl = EncodingUtils.decodeSlashes((String)repositoryNode.name());
            if (repositoryUrls.contains(repositoryUrl)) {
                ICredentialsStore store = this.service.getCredentialsStore(repositoryUrl);
                String[] stringArray2 = repositoryNode.keys();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String key = stringArray2[n4];
                    try {
                        String value = repositoryNode.get(key, null);
                        store.put(key, value, repositoryNode.isEncrypted(key));
                    }
                    catch (StorageException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error migrating secure store credentials for " + repositoryUrl, (Throwable)e));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private Set<String> getRepositoryUrls(Collection<TaskRepository> repositories) {
        HashSet<String> repositoryUrls = new HashSet<String>();
        for (TaskRepository taskRepository : repositories) {
            repositoryUrls.add(taskRepository.getRepositoryUrl());
        }
        return repositoryUrls;
    }
}

