/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.wst.common.frameworks.internal.ExceptionHelper;
import org.eclipse.wst.common.frameworks.internal.IWrappedException;

public class WrappedRuntimeException
extends RuntimeException
implements IWrappedException {
    private static final long serialVersionUID = 2684637746275620101L;
    protected Exception nestedException;

    public WrappedRuntimeException() {
    }

    public WrappedRuntimeException(Exception e) {
        this.setNestedException(e);
    }

    public WrappedRuntimeException(String s) {
        super(s);
    }

    public WrappedRuntimeException(String s, Exception e) {
        super(s);
        this.setNestedException(e);
    }

    @Override
    public String[] getAllMessages() {
        return ExceptionHelper.getAllMessages(this);
    }

    @Override
    public String getConcatenatedMessages() {
        return ExceptionHelper.getConcatenatedMessages(this);
    }

    @Override
    public Exception getInnerMostNestedException() {
        Exception n = this.getNestedException();
        if (n == null) {
            return this;
        }
        if (n instanceof IWrappedException) {
            return ((IWrappedException)((Object)n)).getInnerMostNestedException();
        }
        return n;
    }

    @Override
    public Exception getNestedException() {
        return this.nestedException;
    }

    @Override
    public synchronized Throwable getCause() {
        return this.getNestedException();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.nestedException != null) {
            s.println(this);
            s.println("Stack trace of nested exception:");
            this.nestedException.printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (this.nestedException != null) {
            s.println(this);
            s.println("Stack trace of nested exception:");
            this.nestedException.printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    public void setNestedException(Exception newNestedException) {
        this.nestedException = newNestedException;
    }
}

