/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal;

import java.net.URL;
import java.util.HashSet;
import org.eclipse.cdt.testsrunner.internal.launcher.TestsRunnerProvidersManager;
import org.eclipse.cdt.testsrunner.internal.model.TestingSessionsManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class TestsRunnerPlugin
extends AbstractUIPlugin {
    private static final String PLUGIN_ID = "org.eclipse.cdt.testsrunner";
    private static final IPath ICONS_PATH = new Path("$nl$/icons");
    private static TestsRunnerPlugin plugin;
    private TestsRunnerProvidersManager testsRunnerProvidersManager = new TestsRunnerProvidersManager();
    private TestingSessionsManager testingSessionsManager = new TestingSessionsManager(this.testsRunnerProvidersManager);

    public TestsRunnerPlugin() {
        plugin = this;
    }

    public static TestsRunnerPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public static void log(IStatus status) {
        TestsRunnerPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        TestsRunnerPlugin.log((IStatus)new Status(4, TestsRunnerPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(Throwable e) {
        TestsRunnerPlugin.log((IStatus)new Status(4, TestsRunnerPlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.setDefaultLaunchDelegates();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public TestingSessionsManager getTestingSessionsManager() {
        return this.testingSessionsManager;
    }

    public TestsRunnerProvidersManager getTestsRunnerProvidersManager() {
        return this.testsRunnerProvidersManager;
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        return TestsRunnerPlugin.getDefault().getImageDescriptorImpl(relativePath);
    }

    private ImageDescriptor getImageDescriptorImpl(String relativePath) {
        IPath path = ICONS_PATH.append(relativePath);
        return this.createImageDescriptor(TestsRunnerPlugin.getDefault().getBundle(), path, true);
    }

    public static Image createAutoImage(String path) {
        return TestsRunnerPlugin.getDefault().createAutoImageImpl(path);
    }

    private Image createAutoImageImpl(String path) {
        Image image = this.getImageRegistry().get(path);
        if (image == null) {
            image = TestsRunnerPlugin.getImageDescriptor(path).createImage();
            this.getImageRegistry().put(path, image);
        }
        return image;
    }

    private ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    private void setDefaultLaunchDelegate(ILaunchConfigurationType cfgType, String delegateId, String mode) {
        block4: {
            HashSet<String> modes = new HashSet<String>();
            modes.add(mode);
            try {
                ILaunchDelegate[] delegates;
                if (cfgType.getPreferredDelegate(modes) != null) break block4;
                ILaunchDelegate[] iLaunchDelegateArray = delegates = cfgType.getDelegates(modes);
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchDelegate delegate = iLaunchDelegateArray[n2];
                    if (delegateId.equals(delegate.getId())) {
                        cfgType.setPreferredDelegate(modes, delegate);
                        break;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                TestsRunnerPlugin.log(e);
            }
        }
    }

    private void setDefaultLaunchDelegates() {
        ILaunchManager launchMgr = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configurationType = launchMgr.getLaunchConfigurationType("org.eclipse.cdt.testsrunner.launch.CTestsRunner");
        this.setDefaultLaunchDelegate(configurationType, "org.eclipse.cdt.testsrunner.launch.dsf.runTests", "debug");
        this.setDefaultLaunchDelegate(configurationType, "org.eclipse.cdt.testsrunner.launch.runTests", "run");
    }
}

