/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.ui.view.actions;

import org.eclipse.cdt.testsrunner.internal.ui.view.MessagesViewer;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.ActionsMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;

public class MessageLevelFilterAction
extends Action {
    private MessagesViewer.LevelFilter levelFilter;
    private MessagesViewer messagesViewer;

    public MessageLevelFilterAction(MessagesViewer messagePanel, MessagesViewer.LevelFilter levelFilter, boolean checked) {
        super("", 2);
        this.levelFilter = levelFilter;
        this.messagesViewer = messagePanel;
        if (levelFilter == MessagesViewer.LevelFilter.Info) {
            this.setText(ActionsMessages.MessageLevelFilterAction_infos_text);
            this.setToolTipText(ActionsMessages.MessageLevelFilterAction_infos_tooltip);
        } else if (levelFilter == MessagesViewer.LevelFilter.Warning) {
            this.setText(ActionsMessages.MessageLevelFilterAction_warnings_text);
            this.setToolTipText(ActionsMessages.MessageLevelFilterAction_warnings_tooltip);
        } else if (levelFilter == MessagesViewer.LevelFilter.Error) {
            this.setText(ActionsMessages.MessageLevelFilterAction_errors_text);
            this.setToolTipText(ActionsMessages.MessageLevelFilterAction_errors_tooltip);
        }
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(levelFilter.getImageId()));
        this.setChecked(checked);
        if (checked) {
            messagePanel.addLevelFilter(levelFilter, false);
        }
    }

    public void run() {
        if (this.isChecked()) {
            this.messagesViewer.addLevelFilter(this.levelFilter, true);
        } else {
            this.messagesViewer.removeLevelFilter(this.levelFilter);
        }
    }
}

