/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.model.ICastToArray;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CastToArrayActionHandler
extends AbstractHandler {
    private ICastToArray[] fCastableItems = new ICastToArray[0];
    private IStatus fStatus = null;
    private IWorkbenchPart fTargetPart = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.fTargetPart = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        if (this.getCastToArray() == null || this.getCastToArray().length == 0) {
            return null;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), () -> {
            try {
                this.doAction(this.getCastToArray());
                this.setStatus(null);
            }
            catch (DebugException e) {
                this.setStatus(e.getStatus());
            }
        });
        if (this.getStatus() != null && !this.getStatus().isOK()) {
            IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                CDebugUIPlugin.errorDialog(ActionMessages.getString("CastToArrayActionDelegate.8"), this.getStatus());
            } else {
                CDebugUIPlugin.log(this.getStatus());
            }
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        ICastToArray[] castableItems = this.getCastToArray(evaluationContext);
        this.setBaseEnabled(castableItems.length > 0);
        this.setCastToArray(castableItems);
    }

    private ICastToArray[] getCastToArray(Object evaluationContext) {
        Object s;
        ArrayList<ICastToArray> castableItems = new ArrayList<ICastToArray>();
        if (evaluationContext instanceof IEvaluationContext && (s = ((IEvaluationContext)evaluationContext).getVariable("activeMenuSelection")) instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)s).iterator();
            while (iter.hasNext()) {
                Object element = DebugPlugin.getAdapter(iter.next(), ICastToArray.class);
                if (!(element instanceof ICastToArray) || !((ICastToArray)element).canCastToArray()) continue;
                castableItems.add((ICastToArray)element);
            }
        }
        return castableItems.toArray(new ICastToArray[castableItems.size()]);
    }

    protected ICastToArray[] getCastToArray() {
        return this.fCastableItems;
    }

    protected void setCastToArray(ICastToArray[] castableItems) {
        this.fCastableItems = castableItems;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public void setStatus(IStatus status) {
        this.fStatus = status;
    }

    protected void doAction(ICastToArray[] castableItems) throws DebugException {
        String currentType = castableItems[0].getCurrentType().trim();
        CastToArrayDialog dialog = new CastToArrayDialog(CDebugUIPlugin.getActiveWorkbenchShell(), currentType, 0, 1);
        if (dialog.open() == 0) {
            int firstIndex = dialog.getFirstIndex();
            int lastIndex = dialog.getLength();
            ICastToArray[] iCastToArrayArray = castableItems;
            int n = castableItems.length;
            int n2 = 0;
            while (n2 < n) {
                ICastToArray castableItem = iCastToArrayArray[n2];
                castableItem.castToArray(firstIndex, lastIndex);
                ++n2;
            }
            if (this.getSelectionProvider() != null) {
                this.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object[])castableItems));
            }
        }
    }

    private ISelectionProvider getSelectionProvider() {
        return this.fTargetPart instanceof IDebugView ? ((IDebugView)this.fTargetPart).getViewer() : null;
    }

    protected class CastToArrayDialog
    extends Dialog {
        private String fType;
        private int fFirstIndex;
        private int fLength;
        private Button fOkButton;
        private Label fErrorMessageLabel;
        private Text fFirstIndexText;
        private Text fLengthText;

        public CastToArrayDialog(Shell parentShell, String initialType, int initialStart, int initialLength) {
            super(parentShell);
            this.fType = "";
            this.fFirstIndex = 0;
            this.fLength = 0;
            this.fType = initialType == null ? "" : initialType;
            this.fFirstIndex = initialStart;
            this.fLength = initialLength;
        }

        protected String getType() {
            return this.fType;
        }

        protected int getFirstIndex() {
            return this.fFirstIndex;
        }

        protected int getLength() {
            return this.fLength;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(ActionMessages.getString("CastToArrayActionDelegate.0"));
            newShell.setImage(CDebugImages.get("org.eclipse.cdt.debug.ui.showasarray_co.gif"));
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.fOkButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            this.fFirstIndexText.setText(String.valueOf(this.fFirstIndex));
            this.fLengthText.setText(String.valueOf(this.fLength));
        }

        protected Label getErrorMessageLabel() {
            return this.fErrorMessageLabel;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.createDialogFields(composite);
            this.fErrorMessageLabel = new Label(composite, 0);
            this.fErrorMessageLabel.setLayoutData((Object)new GridData(768));
            this.fErrorMessageLabel.setFont(parent.getFont());
            return composite;
        }

        private void createDialogFields(Composite parent) {
            Composite composite = ControlFactory.createComposite((Composite)parent, (int)4);
            ((GridData)composite.getLayoutData()).widthHint = this.convertHorizontalDLUsToPixels(300);
            ((GridLayout)composite.getLayout()).makeColumnsEqualWidth = true;
            Label label = ControlFactory.createLabel((Composite)composite, (String)ActionMessages.getString("CastToArrayActionDelegate.1"));
            ((GridData)label.getLayoutData()).horizontalSpan = 3;
            this.fFirstIndexText = ControlFactory.createTextField((Composite)composite);
            this.fFirstIndexText.addModifyListener(e -> this.validateInput());
            label = ControlFactory.createLabel((Composite)composite, (String)ActionMessages.getString("CastToArrayActionDelegate.2"));
            ((GridData)label.getLayoutData()).horizontalSpan = 3;
            this.fLengthText = ControlFactory.createTextField((Composite)composite);
            this.fLengthText.addModifyListener(e -> this.validateInput());
        }

        protected void validateInput() {
            boolean enabled = true;
            String message = "";
            String firstIndex = this.fFirstIndexText.getText().trim();
            if (firstIndex.length() == 0) {
                message = ActionMessages.getString("CastToArrayActionDelegate.3");
                enabled = false;
            } else {
                try {
                    Integer.parseInt(firstIndex);
                }
                catch (NumberFormatException e) {
                    message = ActionMessages.getString("CastToArrayActionDelegate.4");
                    enabled = false;
                }
                if (enabled) {
                    String lengthText = this.fLengthText.getText().trim();
                    if (lengthText.length() == 0) {
                        message = ActionMessages.getString("CastToArrayActionDelegate.5");
                        enabled = false;
                    } else {
                        int length = -1;
                        try {
                            length = Integer.parseInt(lengthText);
                        }
                        catch (NumberFormatException e) {
                            message = ActionMessages.getString("CastToArrayActionDelegate.6");
                            enabled = false;
                        }
                        if (enabled && length < 1) {
                            message = ActionMessages.getString("CastToArrayActionDelegate.7");
                            enabled = false;
                        }
                    }
                }
            }
            this.fOkButton.setEnabled(enabled);
            this.getErrorMessageLabel().setText(message);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                String firstIndex = this.fFirstIndexText.getText().trim();
                String lengthText = this.fLengthText.getText().trim();
                try {
                    this.fFirstIndex = Integer.parseInt(firstIndex);
                    this.fLength = Integer.parseInt(lengthText);
                }
                catch (NumberFormatException e) {
                    this.fFirstIndex = 0;
                    this.fLength = 0;
                }
            } else {
                this.fType = null;
            }
            super.buttonPressed(buttonId);
        }
    }
}

