/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFAntlrMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeSpecifierListParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryIntegerParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.event.EventScopeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.stream.StreamScopeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.trace.TraceScopeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ArrayDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.types.SequenceDeclaration;

public final class TypeDeclaratorParser
extends AbstractScopedCommonTreeParser {
    public static final TypeDeclaratorParser INSTANCE = new TypeDeclaratorParser();

    private TypeDeclaratorParser() {
    }

    @Override
    public IDeclaration parse(ICTFMetadataNode typeDeclarator, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        CTFTrace trace = ((Param)param).fTrace;
        ICTFMetadataNode typeSpecifierList = ((Param)param).fListNode;
        IDeclaration declaration = null;
        List<ICTFMetadataNode> children = null;
        LinkedList<@NonNull ICTFMetadataNode> pointers = new LinkedList<ICTFMetadataNode>();
        LinkedList<ICTFMetadataNode> lengths = new LinkedList<ICTFMetadataNode>();
        ICTFMetadataNode identifier = null;
        if (typeDeclarator instanceof CTFAntlrMetadataNode) {
            children = typeDeclarator.getChildren();
            for (ICTFMetadataNode child : children) {
                String type = child.getType();
                if (CTFParser.tokenNames[58].equals(type)) {
                    pointers.add(child);
                    continue;
                }
                if (CTFParser.tokenNames[38].equals(type)) {
                    identifier = child;
                    continue;
                }
                if (CTFParser.tokenNames[102].equals(type)) {
                    lengths.add(child);
                    continue;
                }
                throw TsdlUtils.childTypeError(child);
            }
        } else {
            identifier = typeDeclarator;
        }
        declaration = TypeSpecifierListParser.INSTANCE.parse(typeSpecifierList, new TypeSpecifierListParser.Param(trace, pointers, identifier, scope));
        if (!lengths.isEmpty()) {
            Collections.reverse(lengths);
            for (ICTFMetadataNode length : lengths) {
                List<ICTFMetadataNode> lengthChildren = length.getChildren();
                ICTFMetadataNode first = lengthChildren.get(0);
                if (TsdlUtils.isUnaryInteger(first)) {
                    int arrayLength = UnaryIntegerParser.INSTANCE.parse(first, null).intValue();
                    if (arrayLength < 1) {
                        throw new ParseException("Array length is negative");
                    }
                    declaration = new ArrayDeclaration(arrayLength, declaration);
                    continue;
                }
                if (TsdlUtils.isAnyUnaryString(first)) {
                    String lengthName = TsdlUtils.concatenateUnaryStrings(lengthChildren);
                    if (TypeDeclaratorParser.isSignedIntegerField(lengthName, scope)) {
                        throw new ParseException("Sequence declared with length that is not an unsigned integer");
                    }
                    declaration = new SequenceDeclaration(lengthName, declaration);
                    continue;
                }
                if (TypeDeclaratorParser.isTrace(first)) {
                    String lengthName = TraceScopeParser.INSTANCE.parse(null, new TraceScopeParser.Param(lengthChildren));
                    if (TypeDeclaratorParser.isSignedIntegerField(lengthName, scope)) {
                        throw new ParseException("Sequence declared with length that is not an unsigned integer");
                    }
                    declaration = new SequenceDeclaration(lengthName, declaration);
                    continue;
                }
                if (TypeDeclaratorParser.isStream(first)) {
                    String lengthName = StreamScopeParser.INSTANCE.parse(null, new StreamScopeParser.Param(lengthChildren));
                    if (TypeDeclaratorParser.isSignedIntegerField(lengthName, scope)) {
                        throw new ParseException("Sequence declared with length that is not an unsigned integer");
                    }
                    declaration = new SequenceDeclaration(lengthName, declaration);
                    continue;
                }
                if (TypeDeclaratorParser.isEvent(first)) {
                    String lengthName = EventScopeParser.INSTANCE.parse(null, new EventScopeParser.Param(lengthChildren));
                    if (TypeDeclaratorParser.isSignedIntegerField(lengthName, scope)) {
                        throw new ParseException("Sequence declared with length that is not an unsigned integer");
                    }
                    declaration = new SequenceDeclaration(lengthName, declaration);
                    continue;
                }
                throw TsdlUtils.childTypeError(first);
            }
        }
        if (identifier != null) {
            String text = identifier.getText();
            if (text == null) {
                throw new ParseException("Cannot have unidentified declarator");
            }
            ((Param)param).fBuilder.append(text);
            this.registerType(declaration, text, scope);
        }
        return declaration;
    }

    private static boolean isSignedIntegerField(String lengthName, DeclarationScope scope) throws ParseException {
        IDeclaration decl = scope.lookupIdentifierRecursive(lengthName);
        if (decl instanceof IntegerDeclaration) {
            return ((IntegerDeclaration)decl).isSigned();
        }
        throw new ParseException("Is not an integer: " + lengthName);
    }

    private static boolean isEvent(ICTFMetadataNode first) {
        return CTFParser.tokenNames[99].equals(first.getType());
    }

    private static boolean isStream(ICTFMetadataNode first) {
        return CTFParser.tokenNames[104].equals(first.getType());
    }

    private static boolean isTrace(ICTFMetadataNode first) {
        return CTFParser.tokenNames[110].equals(first.getType());
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fDeclarationScope;
        private final ICTFMetadataNode fListNode;
        private final StringBuilder fBuilder;
        private final CTFTrace fTrace;

        public Param(CTFTrace trace, ICTFMetadataNode listNode, DeclarationScope scope, StringBuilder builder) {
            this.fTrace = trace;
            this.fListNode = listNode;
            this.fDeclarationScope = scope;
            this.fBuilder = builder;
        }
    }
}

