/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TabsToSpacesConverter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.URLHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileCompletionProcessor;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileDoubleClickStrategy;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileEditor;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileHover;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfilePrecentationReconciler;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileReconcilingStrategy;
import org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink.URLHyperlinkWithMacroDetector;
import org.eclipse.linuxtools.internal.rpm.ui.editor.scanners.SpecfilePartitionScanner;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;
import org.eclipse.ui.texteditor.HyperlinkDetectorRegistry;
import org.osgi.framework.FrameworkUtil;

public class SpecfileConfiguration
extends TextSourceViewerConfiguration {
    private SpecfileDoubleClickStrategy doubleClickStrategy;
    private SpecfileEditor editor;
    private IPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, FrameworkUtil.getBundle(SpecfileConfiguration.class).getSymbolicName());

    public SpecfileConfiguration(SpecfileEditor editor) {
        this.editor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return SpecfilePartitionScanner.SPEC_PARTITION_TYPES;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new SpecfileDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new SpecfileHover();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        return new SpecfilePrecentationReconciler();
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.editor != null && this.editor.isEditable()) {
            SpecfileReconcilingStrategy strategy = new SpecfileReconcilingStrategy(this.editor);
            MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            reconciler.setDelay(500);
            return reconciler;
        }
        return null;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        SpecfileCompletionProcessor processor = new SpecfileCompletionProcessor();
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__spec_prep");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__spec_script");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__spec_files");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__spec_changelog");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__spec_packages");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__spec_group");
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(parent -> new DefaultInformationControl(parent, false));
        assistant.enableAutoInsert(true);
        assistant.setStatusLineVisible(true);
        assistant.setStatusMessage(Messages.SpecfileConfiguration_0);
        return assistant;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null) {
            return null;
        }
        Map<String, IAdaptable> targets = this.getHyperlinkDetectorTargets(sourceViewer);
        HyperlinkDetectorRegistry hlDetectorRegistry = EditorsUI.getHyperlinkDetectorRegistry();
        HyperlinkDetectorDescriptor[] hlDetectorDescriptor = hlDetectorRegistry.getHyperlinkDetectorDescriptors();
        ArrayList<AbstractHyperlinkDetector> tempHDList = new ArrayList<AbstractHyperlinkDetector>();
        for (Map.Entry<String, IAdaptable> entry : targets.entrySet()) {
            for (HyperlinkDetectorDescriptor hdd : hlDetectorDescriptor) {
                try {
                    AbstractHyperlinkDetector ahld = (AbstractHyperlinkDetector)hdd.createHyperlinkDetectorImplementation();
                    if (!hdd.getTargetId().equals(entry.getKey()) || ahld instanceof URLHyperlinkDetector && !(ahld instanceof URLHyperlinkWithMacroDetector)) continue;
                    ahld.setContext(entry.getValue());
                    tempHDList.add(ahld);
                }
                catch (CoreException e) {
                    SpecfileLog.logError(e);
                }
            }
        }
        if (!tempHDList.isEmpty()) {
            return tempHDList.toArray(new IHyperlinkDetector[tempHDList.size()]);
        }
        return null;
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditorTarget", this.editor);
        targets.put("org.eclipse.ui.DefaultTextEditor", this.editor);
        return targets;
    }

    private int getTabSize() {
        return this.store.getInt("NbrOfSpacesForTab");
    }

    private boolean isTabConversionEnabled() {
        return this.store.getBoolean("SpacesForTabs");
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.isTabConversionEnabled()) {
            TabsToSpacesConverter tabsConverter = new TabsToSpacesConverter();
            tabsConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
            tabsConverter.setNumberOfSpacesPerTab(this.getTabSize());
            return new IAutoEditStrategy[]{tabsConverter};
        }
        return null;
    }
}

