/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.docker.launcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.ICommandLauncherFactory;
import org.eclipse.cdt.core.ICommandLauncherFactory2;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CIncludeFileEntry;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICIncludeFileEntry;
import org.eclipse.cdt.core.settings.model.ICIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.docker.launcher.ContainerCommandLauncher;
import org.eclipse.cdt.docker.launcher.DockerLaunchUIPlugin;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescriptionCache;
import org.eclipse.cdt.internal.docker.launcher.Messages;
import org.eclipse.cdt.managedbuilder.buildproperties.IOptionalBuildProperties;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildConfigurationData;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.docker.ui.launch.ContainerLauncher;
import org.osgi.framework.Bundle;

public class ContainerCommandLauncherFactory
implements ICommandLauncherFactory,
ICommandLauncherFactory2 {
    private IProject m_project;

    private List<String> filterOutLocalPaths(List<String> dirs) {
        String prj = this.m_project.getLocation().toString();
        return dirs.stream().filter(x -> !x.startsWith(prj) && !x.startsWith("/${ProjName}")).collect(Collectors.toList());
    }

    private String normalizeToPathName(String name) {
        String cleanName = name.replace("unix:///", "unix_");
        cleanName = cleanName.replace("tcp://", "tcp_");
        cleanName = cleanName.replaceAll("[:/.]", "_");
        assert (Path.ROOT.isValidSegment(cleanName)) : "Invalid Path - please file a bug";
        return cleanName;
    }

    private IPath getHostMirrorPath(ImageConnection imgCon) {
        IPath pluginPath = Platform.getStateLocation((Bundle)Platform.getBundle((String)"org.eclipse.cdt.docker.launcher")).append("HEADERS");
        pluginPath = pluginPath.append(this.normalizeToPathName(imgCon.connectionName));
        pluginPath = pluginPath.append(this.normalizeToPathName(imgCon.imageName));
        return pluginPath;
    }

    private boolean getPaths(ImageConnection imgCon, List<String> paths) {
        ContainerLauncher launcher = new ContainerLauncher();
        IPath targetPath = this.getHostMirrorPath(imgCon);
        int rv = launcher.fetchContainerDirs(imgCon.connectionName, imgCon.imageName, paths, null, targetPath);
        return rv == 0;
    }

    private ImageConnection getImgCnn() {
        ICConfigurationDescription cfgd = CoreModel.getDefault().getProjectDescription(this.m_project).getActiveConfiguration();
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd);
        IOptionalBuildProperties props = cfg.getOptionalBuildProperties();
        if (props == null) {
            return null;
        }
        String enablementProperty = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement");
        if (enablementProperty == null) {
            return null;
        }
        if (!Boolean.parseBoolean(enablementProperty)) {
            return null;
        }
        String connectionName = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection");
        String imageName = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image");
        if (connectionName == null || connectionName.isEmpty() || imageName == null || imageName.isEmpty()) {
            DockerLaunchUIPlugin.logErrorMessage(Messages.ContainerCommandLauncher_invalid_values);
            return null;
        }
        return new ImageConnection(connectionName, imageName);
    }

    public ICommandLauncher getCommandLauncher(IProject project) {
        this.m_project = project;
        ICConfigurationDescription cfgd = CoreModel.getDefault().getProjectDescription(project, false).getActiveConfiguration();
        return this.getCommandLauncher(cfgd);
    }

    public ICommandLauncher getCommandLauncher(ICConfigurationDescription cfgd) {
        boolean enableContainer;
        String enablementProperty;
        IConfiguration cfg = null;
        try {
            CConfigurationData data;
            if (cfgd instanceof CConfigurationDescriptionCache && (data = ((CConfigurationDescriptionCache)cfgd).getConfigurationData()) instanceof BuildConfigurationData) {
                cfg = ((BuildConfigurationData)data).getConfiguration();
            }
            if (cfg == null) {
                cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd);
            }
        }
        catch (Exception data) {
            // empty catch block
        }
        if (cfg == null) {
            return null;
        }
        this.m_project = (IProject)cfg.getManagedProject().getOwner();
        IOptionalBuildProperties props = cfg.getOptionalBuildProperties();
        if (props != null && (enablementProperty = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement")) != null && (enableContainer = Boolean.parseBoolean(enablementProperty))) {
            return new ContainerCommandLauncher();
        }
        return null;
    }

    public ICommandLauncher getCommandLauncher(ICBuildConfiguration cfgd) {
        try {
            this.m_project = cfgd.getBuildConfiguration().getProject();
        }
        catch (CoreException e1) {
            return null;
        }
        try {
            IToolChain toolchain = cfgd.getToolChain();
            if (toolchain != null && "linux-container".equals(toolchain.getProperty("os"))) {
                return new ContainerCommandLauncher();
            }
        }
        catch (CoreException e) {
            DockerLaunchUIPlugin.log(e);
        }
        return null;
    }

    public void registerLanguageSettingEntries(IProject project, List<? extends ICLanguageSettingEntry> langEntries) {
        if (langEntries == null) {
            return;
        }
        List<? extends ICLanguageSettingEntry> entries = langEntries;
        List<String> paths = new ArrayList<String>();
        for (ICLanguageSettingEntry iCLanguageSettingEntry : entries) {
            if (iCLanguageSettingEntry instanceof ICIncludePathEntry) {
                paths.add(iCLanguageSettingEntry.getValue());
                continue;
            }
            if (!(iCLanguageSettingEntry instanceof ICIncludeFileEntry)) continue;
            paths.add(new Path(iCLanguageSettingEntry.getValue()).removeLastSegments(1).toString());
        }
        if ((paths = this.filterOutLocalPaths(paths)).size() == 0) {
            return;
        }
        ImageConnection imageConnection = this.getImgCnn();
        this.getPaths(imageConnection, paths);
    }

    public List<String> verifyIncludePaths(ICBuildConfiguration cfgd, List<String> includePaths) {
        IToolChain toolchain = null;
        try {
            toolchain = cfgd.getToolChain();
        }
        catch (CoreException e) {
            DockerLaunchUIPlugin.log(e);
        }
        if (toolchain == null) {
            return includePaths;
        }
        if (!"linux-container".equals(toolchain.getProperty("os"))) {
            DockerLaunchUIPlugin.logErrorMessage(Messages.ContainerCommandLauncher_invalid_container_type);
            return includePaths;
        }
        String connectionName = toolchain.getProperty("connection_uri");
        String imageName = toolchain.getProperty("image_id");
        if (connectionName == null || connectionName.isEmpty() || imageName == null || imageName.isEmpty()) {
            DockerLaunchUIPlugin.logErrorMessage(Messages.ContainerCommandLauncher_invalid_values);
            return includePaths;
        }
        ImageConnection imgCnn = new ImageConnection(connectionName, imageName);
        if (includePaths.isEmpty()) {
            IPath pluginPath = this.getHostMirrorPath(imgCnn);
            toolchain.setProperty("cdt.needScannerRefresh", pluginPath.toFile().exists() ? "false" : "true");
            return includePaths;
        }
        List<String> fetchPaths = this.filterOutLocalPaths(includePaths);
        if (fetchPaths.size() == 0) {
            return includePaths;
        }
        if (!this.getPaths(imgCnn, fetchPaths)) {
            return includePaths;
        }
        IPath tpath = this.getHostMirrorPath(imgCnn);
        Set copiedVolumes = ContainerLauncher.getCopiedVolumes((IPath)tpath);
        ArrayList<String> newEntries = new ArrayList<String>();
        for (String includePath : includePaths) {
            IPath path = new Path(includePath).makeAbsolute();
            boolean found = false;
            for (IPath copiedVolume : copiedVolumes) {
                if (!copiedVolume.isPrefixOf(path)) continue;
                IPath newPath = tpath.append(path);
                String newEntry = newPath.toOSString();
                newEntries.add(newEntry);
                found = true;
                break;
            }
            if (found) continue;
            newEntries.add(path.toPortableString());
        }
        return newEntries;
    }

    public List<ICLanguageSettingEntry> verifyLanguageSettingEntries(IProject project, List<ICLanguageSettingEntry> entries) {
        if (entries == null) {
            return null;
        }
        ICConfigurationDescription cfgd = CoreModel.getDefault().getProjectDescription(project).getActiveConfiguration();
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgd);
        IOptionalBuildProperties props = cfg.getOptionalBuildProperties();
        if (props == null) {
            return entries;
        }
        String enablementProperty = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.enablement");
        if (enablementProperty == null) {
            return entries;
        }
        boolean enableContainer = Boolean.parseBoolean(enablementProperty);
        if (!enableContainer) {
            return entries;
        }
        String connectionName = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.connection");
        String imageName = props.getProperty("org.eclipse.cdt.docker.launcher.containerbuild.property.image");
        if (connectionName == null || connectionName.isEmpty() || imageName == null || imageName.isEmpty()) {
            DockerLaunchUIPlugin.logErrorMessage(Messages.ContainerCommandLauncher_invalid_values);
            return entries;
        }
        IPath tpath = this.getHostMirrorPath(new ImageConnection(connectionName, imageName));
        Set copiedVolumes = ContainerLauncher.getCopiedVolumes((IPath)tpath);
        ArrayList<ICLanguageSettingEntry> newEntries = new ArrayList<ICLanguageSettingEntry>();
        for (ICLanguageSettingEntry entry : entries) {
            CIncludePathEntry newEntry;
            IPath newPath;
            Path tp;
            if (entry instanceof ICIncludePathEntry) {
                tp = new Path(((ICIncludePathEntry)entry).getName().toString());
                if (copiedVolumes.stream().anyMatch(p -> p.isPrefixOf((IPath)tp))) {
                    newPath = tpath.append(entry.getName());
                    newEntry = new CIncludePathEntry(newPath.toString(), entry.getFlags());
                    newEntries.add((ICLanguageSettingEntry)newEntry);
                    continue;
                }
            }
            if (entry instanceof ICIncludeFileEntry) {
                tp = new Path(((ICIncludeFileEntry)entry).getName()).removeLastSegments(1);
                if (copiedVolumes.stream().anyMatch(arg_0 -> ContainerCommandLauncherFactory.lambda$2((IPath)tp, arg_0))) {
                    newPath = tpath.append(entry.getName());
                    newEntry = new CIncludeFileEntry(newPath.toString(), entry.getFlags());
                    newEntries.add((ICLanguageSettingEntry)newEntry);
                    continue;
                }
            }
            newEntries.add(entry);
        }
        return newEntries;
    }

    private static /* synthetic */ boolean lambda$2(IPath iPath, IPath p) {
        return p.isPrefixOf(iPath);
    }

    private class ImageConnection {
        final String connectionName;
        final String imageName;

        public ImageConnection(String connectionName, String imageName) {
            this.connectionName = connectionName;
            this.imageName = imageName;
        }
    }
}

