/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.assist;

import java.util.ArrayList;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class MultiplexingContentAssistProcessor
implements IContentAssistProcessor {
    private IContentAssistProcessor[] delegates;
    private final char[] autoActivationCharacters = new char[0];
    private final char[] contextInformationCharacters = new char[0];

    public void addDelegate(IContentAssistProcessor processor) {
        if (this.delegates == null) {
            this.delegates = new IContentAssistProcessor[]{processor};
        } else {
            IContentAssistProcessor[] processors = new IContentAssistProcessor[this.delegates.length + 1];
            System.arraycopy(this.delegates, 0, processors, 0, this.delegates.length);
            processors[this.delegates.length] = processor;
            this.delegates = processors;
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] allProposals = null;
        IContentAssistProcessor[] iContentAssistProcessorArray = this.delegates;
        int n = this.delegates.length;
        int n2 = 0;
        while (n2 < n) {
            IContentAssistProcessor delegate = iContentAssistProcessorArray[n2];
            allProposals = this.merge(allProposals, delegate.computeCompletionProposals(viewer, offset));
            ++n2;
        }
        return allProposals;
    }

    private ICompletionProposal[] merge(ICompletionProposal[] proposals1, ICompletionProposal[] proposals2) {
        ICompletionProposal[] proposals = proposals1;
        if (proposals1 == null) {
            proposals = proposals2;
        } else if (proposals2 == null) {
            proposals = proposals1;
        } else {
            proposals = new ICompletionProposal[proposals1.length + proposals2.length];
            System.arraycopy(proposals1, 0, proposals, 0, proposals1.length);
            System.arraycopy(proposals2, 0, proposals, proposals1.length, proposals2.length);
        }
        return proposals;
    }

    private IContextInformation[] merge(IContextInformation[] information1, IContextInformation[] information2) {
        IContextInformation[] information = information1;
        if (information1 == null) {
            information = information2;
        } else if (information2 == null) {
            information = information1;
        } else {
            information = new IContextInformation[information1.length + information2.length];
            System.arraycopy(information1, 0, information, 0, information1.length);
            System.arraycopy(information2, 0, information, information1.length, information2.length);
        }
        return information;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        IContextInformation[] allInformation = null;
        IContentAssistProcessor[] iContentAssistProcessorArray = this.delegates;
        int n = this.delegates.length;
        int n2 = 0;
        while (n2 < n) {
            IContentAssistProcessor delegate = iContentAssistProcessorArray[n2];
            IContextInformation[] information = delegate.computeContextInformation(viewer, offset);
            allInformation = this.merge(allInformation, information);
            ++n2;
        }
        return allInformation;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.autoActivationCharacters;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.contextInformationCharacters;
    }

    public IContextInformationValidator getContextInformationValidator() {
        ArrayList validators = null;
        IContentAssistProcessor[] iContentAssistProcessorArray = this.delegates;
        int n = this.delegates.length;
        int n2 = 0;
        while (n2 < n) {
            IContentAssistProcessor delegate = iContentAssistProcessorArray[n2];
            IContextInformationValidator validator = delegate.getContextInformationValidator();
            if (validator != null && validators == null) {
                validators = new ArrayList();
            }
            ++n2;
        }
        if (validators != null) {
            return (IContextInformationValidator)validators.get(0);
        }
        return null;
    }

    public String getErrorMessage() {
        IContentAssistProcessor[] iContentAssistProcessorArray = this.delegates;
        int n = this.delegates.length;
        int n2 = 0;
        while (n2 < n) {
            IContentAssistProcessor delegate = iContentAssistProcessorArray[n2];
            String message = delegate.getErrorMessage();
            if (message != null) {
                return message;
            }
            ++n2;
        }
        return null;
    }
}

