/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import jakarta.inject.Inject;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class LazyStackRenderer
extends SWTPartRenderer {
    private final EventHandler lazyLoader = event -> {
        Object element = event.getProperty("ChangedElement");
        if (!(element instanceof MGenericStack)) {
            return;
        }
        MGenericStack stack = (MGenericStack)element;
        if (stack.getRenderer() != this) {
            return;
        }
        LazyStackRenderer lsr = (LazyStackRenderer)((Object)((Object)stack.getRenderer()));
        Control widget = (Control)stack.getWidget();
        widget.setRedraw(false);
        try {
            MUIElement oldSel = (MUIElement)event.getProperty("OldValue");
            if (oldSel != null) {
                this.hideElementRecursive(oldSel);
            }
            if (stack.getSelectedElement() != null) {
                lsr.showTab(stack.getSelectedElement());
            }
        }
        finally {
            widget.setRedraw(true);
        }
    };

    public void init(IEventBroker eventBroker) {
        eventBroker.unsubscribe(this.lazyLoader);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", this.lazyLoader);
    }

    public void contextDisposed(IEventBroker eventBroker) {
        eventBroker.unsubscribe(this.lazyLoader);
    }

    public void postProcess(MUIElement element) {
        if (!(element instanceof MPerspectiveStack || element instanceof MGenericStack && !this.isMinimizedStack(element))) {
            return;
        }
        MGenericStack stack = (MGenericStack)element;
        MUIElement selPart = stack.getSelectedElement();
        if (selPart != null) {
            this.showTab(selPart);
        } else if (stack.getChildren().size() > 0) {
            for (MUIElement kid : stack.getChildren()) {
                if (!kid.isToBeRendered() || !kid.isVisible()) continue;
                stack.setSelectedElement(kid);
                break;
            }
        }
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        if (parentElement.getSelectedElement() != element) {
            this.hideElementRecursive(element);
        }
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        this.hideElementRecursive(child);
    }

    @Inject
    @Optional
    private void subscribePartTopicToolbar(@UIEventTopic(value="org/eclipse/e4/ui/model/basic/Part/toolbar/*") Event event) {
        MElementContainer parent;
        Object obj = event.getProperty("ChangedElement");
        Object value = event.getProperty("NewValue");
        if (!(obj instanceof MPart) || !(value instanceof MToolBar)) {
            return;
        }
        MUIElement element = (MUIElement)obj;
        if (element.getCurSharedRef() != null) {
            element = element.getCurSharedRef();
        }
        if ((parent = element.getParent()).getRenderer() != this) {
            return;
        }
        MToolBar toolbar = (MToolBar)value;
        if (element == parent.getSelectedElement()) {
            toolbar.setVisible(true);
        } else {
            toolbar.setVisible(false);
        }
    }

    @Override
    public void processContents(MElementContainer<MUIElement> me) {
        IPresentationEngine renderer = (IPresentationEngine)this.context.get(IPresentationEngine.class);
        for (MUIElement element : me.getChildren()) {
            this.hideElementRecursive(element);
            if (!element.isToBeRendered() || !element.isVisible()) continue;
            boolean lazy = true;
            if (element instanceof MPlaceholder) {
                MPlaceholder placeholder = (MPlaceholder)element;
                Assert.isNotNull((Object)placeholder.getRef(), (String)("Placeholder " + placeholder.getElementId() + " does not point to a valid reference"));
                if (placeholder.getRef().getTags().contains("NoRestore")) continue;
                if (placeholder.getRef() instanceof MPart && placeholder.getRef().getWidget() != null) {
                    lazy = false;
                }
            }
            if (lazy) {
                this.createTab(me, element);
                continue;
            }
            renderer.createGui(element);
        }
    }

    protected void createTab(MElementContainer<MUIElement> me, MUIElement part) {
    }

    protected void showTab(MUIElement element) {
        MUIElement curSel = element.getParent().getSelectedElement();
        if (curSel != null) {
            this.showElementRecursive(curSel);
        }
    }

    private void hideElementRecursive(MUIElement element) {
        block8: {
            block9: {
                block7: {
                    MToolBar toolbar;
                    MPlaceholder ph;
                    if (element == null) {
                        return;
                    }
                    if (element instanceof MPlaceholder && (ph = (MPlaceholder)element).getRef() != null && ph.getRef().getCurSharedRef() == ph) {
                        this.hideElementRecursive(ph.getRef());
                    }
                    if (element instanceof MWindow) {
                        element.setVisible(false);
                    }
                    if (element instanceof MPart && (toolbar = ((MPart)element).getToolbar()) != null) {
                        toolbar.setVisible(false);
                    }
                    if (!(element instanceof MGenericStack)) break block7;
                    MGenericStack container = (MGenericStack)element;
                    MUIElement curSel = container.getSelectedElement();
                    this.hideElementRecursive(curSel);
                    break block8;
                }
                if (!(element instanceof MElementContainer)) break block8;
                MElementContainer container = (MElementContainer)element;
                for (MUIElement childElement : container.getChildren()) {
                    this.hideElementRecursive(childElement);
                }
                if (!(element instanceof MWindow)) break block9;
                for (MWindow w : ((MWindow)element).getWindows()) {
                    this.hideElementRecursive((MUIElement)w);
                }
                break block8;
            }
            if (!(element instanceof MPerspective)) break block8;
            for (MWindow w : ((MPerspective)element).getWindows()) {
                this.hideElementRecursive((MUIElement)w);
            }
        }
    }

    private void showElementRecursive(MUIElement element) {
        IEclipseContext context;
        MToolBar toolbar;
        if (!element.isToBeRendered()) {
            return;
        }
        if (element instanceof MPartStack) {
            MUIElement curSel;
            MPartStack stackModel = (MPartStack)element;
            if (element.getRenderer() instanceof StackRenderer && (curSel = stackModel.getSelectedElement()) != null) {
                this.showElementRecursive(curSel);
            }
        }
        if (element instanceof MPlaceholder) {
            MPlaceholder ph = (MPlaceholder)element;
            MUIElement ref = ph.getRef();
            ref.setCurSharedRef(ph);
            Composite phComp = (Composite)ph.getWidget();
            Control refCtrl = (Control)ph.getRef().getWidget();
            if (phComp != null && refCtrl != null && refCtrl.getParent() != phComp) {
                refCtrl.setParent(phComp);
                refCtrl.requestLayout();
            }
            this.showElementRecursive(ref);
        }
        if (element instanceof MPart && (toolbar = ((MPart)element).getToolbar()) != null) {
            Object object;
            toolbar.setVisible(true);
            AbstractPartRenderer renderer = (AbstractPartRenderer)element.getRenderer();
            if (renderer != null && (object = renderer.getUIContainer((MUIElement)toolbar)) instanceof Composite) {
                Control control;
                Composite composite = (Composite)object;
                Object object2 = toolbar.getWidget();
                if (object2 instanceof Control && (control = (Control)object2).getParent() != composite) {
                    control.setParent(composite);
                }
            }
        }
        if (element instanceof MContext && (context = ((MContext)element).getContext()) != null) {
            IEclipseContext newParentContext = this.modelService.getContainingContext(element);
            if (context.getParent() != newParentContext) {
                context.setParent(newParentContext);
            }
        }
        Shell layoutShellLater = null;
        if (element instanceof MWindow && element.getWidget() != null) {
            int visCount = 0;
            for (MUIElement kid : ((MWindow)element).getChildren()) {
                if (!kid.isToBeRendered() || !kid.isVisible()) continue;
                ++visCount;
            }
            if (visCount > 0) {
                element.setVisible(true);
                Object widget = element.getWidget();
                if (widget instanceof Shell) {
                    Shell shell;
                    layoutShellLater = shell = (Shell)widget;
                }
            }
        }
        if (element instanceof MGenericStack) {
            MGenericStack container = (MGenericStack)element;
            MUIElement curSel = container.getSelectedElement();
            if (curSel == null && container.getChildren().size() > 0) {
                curSel = (MUIElement)container.getChildren().get(0);
            }
            if (curSel != null) {
                this.showElementRecursive(curSel);
            }
        } else if (element instanceof MElementContainer) {
            MElementContainer container = (MElementContainer)element;
            ArrayList kids = new ArrayList(container.getChildren());
            for (MUIElement childElement : kids) {
                this.showElementRecursive(childElement);
            }
            if (element instanceof MWindow) {
                for (MWindow w : ((MWindow)element).getWindows()) {
                    this.showElementRecursive((MUIElement)w);
                }
            } else if (element instanceof MPerspective) {
                for (MWindow w : ((MPerspective)element).getWindows()) {
                    this.showElementRecursive((MUIElement)w);
                }
            }
        }
        if (layoutShellLater != null) {
            layoutShellLater.layout(true, true);
        }
    }

    private boolean isMinimizedStack(MUIElement stack) {
        return stack.getTags().contains("Minimized") && !stack.getTags().contains("active");
    }
}

