/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.Gist;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class GistService
extends GitHubService {
    public GistService() {
    }

    public GistService(GitHubClient client) {
        super(client);
    }

    protected String checkGistId(String gistId) {
        if (gistId == null) {
            throw new IllegalArgumentException("Gist id cannot be null");
        }
        if (gistId.length() == 0) {
            throw new IllegalArgumentException("Gist id cannot be empty");
        }
        return gistId;
    }

    public Gist getGist(String id) throws IOException {
        this.checkGistId(id);
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(id);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)Gist.class));
        return (Gist)this.client.get(request).getBody();
    }

    public PageIterator<Gist> pageStarredGists() {
        return this.pageStarredGists(100);
    }

    public PageIterator<Gist> pageStarredGists(int size) {
        return this.pageStarredGists(1, size);
    }

    public PageIterator<Gist> pageStarredGists(int start, int size) {
        PagedRequest request = this.createPagedRequest(start, size);
        request.setUri("/gists/starred");
        request.setType(new TypeToken<List<Gist>>(){}.getType());
        return this.createPageIterator(request);
    }

    public List<Gist> getStarredGists() throws IOException {
        return this.getAll(this.pageStarredGists());
    }

    protected PagedRequest<Gist> createUserGistRequest(String user, int start, int size) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/users");
        uri.append('/').append(user);
        uri.append("/gists");
        PagedRequest<Gist> request = this.createPagedRequest(start, size);
        request.setUri(uri).setType(new TypeToken<List<Gist>>(){}.getType());
        return request;
    }

    public List<Gist> getGists(String user) throws IOException {
        return this.getAll(this.pageGists(user));
    }

    public PageIterator<Gist> pageGists(String user) {
        return this.pageGists(user, 100);
    }

    public PageIterator<Gist> pageGists(String user, int size) {
        return this.pageGists(user, 1, size);
    }

    public PageIterator<Gist> pageGists(String user, int start, int size) {
        PagedRequest<Gist> request = this.createUserGistRequest(user, start, size);
        return this.createPageIterator(request);
    }

    public PageIterator<Gist> pagePublicGists() {
        return this.pagePublicGists(100);
    }

    public PageIterator<Gist> pagePublicGists(int size) {
        return this.pagePublicGists(1, size);
    }

    public PageIterator<Gist> pagePublicGists(int start, int size) {
        PagedRequest request = this.createPagedRequest(start, size);
        request.setUri("/gists/public");
        request.setType(new TypeToken<List<Gist>>(){}.getType());
        return this.createPageIterator(request);
    }

    public Gist createGist(Gist gist) throws IOException {
        if (gist == null) {
            throw new IllegalArgumentException("Gist cannot be null");
        }
        return (Gist)this.client.post("/gists", gist, (Type)((Object)Gist.class));
    }

    public Gist updateGist(Gist gist) throws IOException {
        if (gist == null) {
            throw new IllegalArgumentException("Gist cannot be null");
        }
        String id = gist.getId();
        this.checkGistId(id);
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(id);
        return (Gist)this.client.post(uri.toString(), gist, (Type)((Object)Gist.class));
    }

    public Comment createComment(String gistId, String comment) throws IOException {
        this.checkGistId(gistId);
        if (comment == null) {
            throw new IllegalArgumentException("Gist comment cannot be null");
        }
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(gistId);
        uri.append("/comments");
        Map<String, String> params = Collections.singletonMap("body", comment);
        return (Comment)this.client.post(uri.toString(), params, (Type)((Object)Comment.class));
    }

    public List<Comment> getComments(String gistId) throws IOException {
        this.checkGistId(gistId);
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(gistId);
        uri.append("/comments");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri).setType(new TypeToken<List<Comment>>(){}.getType());
        return this.getAll(request);
    }

    public void deleteGist(String gistId) throws IOException {
        this.checkGistId(gistId);
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(gistId);
        this.client.delete(uri.toString());
    }

    public Comment getComment(long commentId) throws IOException {
        StringBuilder uri = new StringBuilder("/gists/comments");
        uri.append('/').append(commentId);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)Comment.class));
        return (Comment)this.client.get(request).getBody();
    }

    public Comment editComment(Comment comment) throws IOException {
        if (comment == null) {
            throw new IllegalArgumentException("Comment cannot be null");
        }
        StringBuilder uri = new StringBuilder("/gists/comments");
        uri.append('/').append(comment.getId());
        return (Comment)this.client.post(uri.toString(), comment, (Type)((Object)Comment.class));
    }

    public void deleteComment(long commentId) throws IOException {
        StringBuilder uri = new StringBuilder("/gists/comments");
        uri.append('/').append(commentId);
        this.client.delete(uri.toString());
    }

    public void starGist(String gistId) throws IOException {
        this.checkGistId(gistId);
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(gistId);
        uri.append("/star");
        this.client.put(uri.toString());
    }

    public void unstarGist(String gistId) throws IOException {
        this.checkGistId(gistId);
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(gistId);
        uri.append("/star");
        this.client.delete(uri.toString());
    }

    public boolean isStarred(String gistId) throws IOException {
        this.checkGistId(gistId);
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(gistId);
        uri.append("/star");
        return this.check(uri.toString());
    }

    public Gist forkGist(String gistId) throws IOException {
        this.checkGistId(gistId);
        StringBuilder uri = new StringBuilder("/gists");
        uri.append('/').append(gistId);
        uri.append("/fork");
        return (Gist)this.client.post(uri.toString(), null, (Type)((Object)Gist.class));
    }
}

