/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.DateUtil;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.GradientToolTip;
import org.eclipse.mylyn.commons.ui.PlatformUiUtil;
import org.eclipse.mylyn.commons.ui.compatibility.CommonFonts;
import org.eclipse.mylyn.commons.workbench.forms.ScalingHyperlink;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.TaskScalingHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotifier;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.Messages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskScheduleContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.WorkweekProgressBar;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TaskListToolTip
extends GradientToolTip {
    private static final int MAX_WIDTH = 600;
    private static final int X_SHIFT = PlatformUiUtil.getToolTipXShift();
    private static final int Y_SHIFT = 1;
    private IRepositoryElement currentTipElement;
    private final List<TaskListToolTipListener> listeners = new ArrayList<TaskListToolTipListener>();
    private boolean visible;
    private boolean triggeredByMouse = true;
    private final Control control;
    private final Color titleColor;
    private boolean enabled;

    public TaskListToolTip(Control control) {
        super(control);
        this.control = control;
        this.setEnabled(true);
        this.setShift(new Point(1, 1));
        this.titleColor = TasksUiPlugin.getDefault().getFormColors(control.getDisplay()).getColor("org.eclipse.ui.forms.TITLE");
    }

    public void dispose() {
        this.hide();
    }

    protected void afterHideToolTip(Event event) {
        this.triggeredByMouse = true;
        this.visible = false;
        TaskListToolTipListener[] taskListToolTipListenerArray = this.listeners.toArray(new TaskListToolTipListener[0]);
        int n = taskListToolTipListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TaskListToolTipListener listener = taskListToolTipListenerArray[n2];
            listener.toolTipHidden(event);
            ++n2;
        }
    }

    public void addTaskListToolTipListener(TaskListToolTipListener listener) {
        this.listeners.add(listener);
    }

    public void removeTaskListToolTipListener(TaskListToolTipListener listener) {
        this.listeners.remove(listener);
    }

    private IRepositoryElement getTaskListElement(Object hoverObject) {
        Object data;
        if (hoverObject instanceof ScalingHyperlink) {
            TaskScalingHyperlink hyperlink = (TaskScalingHyperlink)((Object)hoverObject);
            return hyperlink.getTask();
        }
        if (hoverObject instanceof Widget && (data = ((Widget)hoverObject).getData()) != null) {
            if (data instanceof ITaskContainer) {
                return (IRepositoryElement)data;
            }
            if (data instanceof IAdaptable) {
                return (IRepositoryElement)((IAdaptable)data).getAdapter(AbstractTaskContainer.class);
            }
        }
        return null;
    }

    private String getTitleText(IRepositoryElement element) {
        if (element instanceof ScheduledTaskContainer) {
            StringBuilder sb = new StringBuilder();
            sb.append(((ScheduledTaskContainer)element).getShortSummary());
            if (!(element instanceof TaskScheduleContentProvider.StateTaskContainer)) {
                Calendar start = ((ScheduledTaskContainer)element).getDateRange().getStartDate();
                sb.append(" - ");
                sb.append(DateFormat.getDateInstance((int)1).format(start.getTime()));
            }
            return sb.toString();
        }
        if (element instanceof IRepositoryQuery) {
            IRepositoryQuery query = (IRepositoryQuery)element;
            StringBuilder sb = new StringBuilder();
            sb.append(element.getSummary());
            sb.append("  [");
            sb.append(this.getRepositoryLabel(query.getConnectorKind(), query.getRepositoryUrl()));
            sb.append("]");
            return sb.toString();
        }
        if (element instanceof ITask) {
            return ((ITask)element).getSummary();
        }
        return new TaskElementLabelProvider(false).getText(element);
    }

    private String getDetailsText(IRepositoryElement element) {
        if (element instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer container = (ScheduledTaskContainer)element;
            int estimateTotal = 0;
            long activeTotal = 0L;
            for (ITask child : container.getChildren()) {
                if (!(child instanceof AbstractTask)) continue;
                estimateTotal += ((AbstractTask)child).getEstimatedTimeHours();
                activeTotal += TasksUiPlugin.getTaskActivityManager().getElapsedTime(child, container.getDateRange());
            }
            StringBuilder sb = new StringBuilder();
            this.appendEstimateAndActive(sb, estimateTotal, activeTotal);
            return sb.toString();
        }
        if (element instanceof ITask) {
            String taskKind;
            String key;
            ITask task = (ITask)element;
            StringBuilder sb = new StringBuilder();
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(task.getConnectorKind());
            String kindLabel = null;
            if (connectorUi != null) {
                kindLabel = connectorUi.getTaskKindLabel(task);
                sb.append(kindLabel);
            }
            if ((key = task.getTaskKey()) != null) {
                sb.append(" ");
                sb.append(key);
            }
            if ((taskKind = task.getTaskKind()) != null && taskKind.length() > 0 && !taskKind.equals(kindLabel)) {
                sb.append(" (");
                sb.append(taskKind);
                sb.append(") ");
            }
            sb.append(", ");
            String priorityLabel = task.getAttribute("task.common.priority.label");
            if (StringUtils.isEmpty((CharSequence)priorityLabel)) {
                priorityLabel = task.getPriority();
            }
            sb.append(priorityLabel);
            sb.append("  [");
            sb.append(this.getRepositoryLabel(task.getConnectorKind(), task.getRepositoryUrl()));
            sb.append("]");
            return sb.toString();
        }
        return null;
    }

    private void appendEstimateAndActive(StringBuilder sb, int estimateTotal, long activeTotal) {
        sb.append(NLS.bind((String)Messages.TaskListToolTip_Estimate, (Object)estimateTotal));
        sb.append("\n");
        if (TasksUiInternal.isActivityTrackingEnabled()) {
            sb.append(NLS.bind((String)Messages.TaskListToolTip_Active_X, (Object)DateUtil.getFormattedDurationShort((long)activeTotal)));
            sb.append("\n");
        }
    }

    private String getRepositoryLabel(String repositoryKind, String repositoryUrl) {
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(repositoryKind, repositoryUrl);
        if (repository != null) {
            String label = repository.getRepositoryLabel();
            if (label.indexOf("//") != -1) {
                return label.substring(repository.getRepositoryUrl().indexOf("//") + 2);
            }
            return label;
        }
        return "";
    }

    private String getOwnerText(IRepositoryElement element) {
        if (element instanceof ITask && !(element instanceof LocalTask)) {
            String owner = ((ITask)element).getOwner();
            if (StringUtils.isNotEmpty((CharSequence)owner)) {
                return NLS.bind((String)Messages.TaskListToolTip_Assigned_to_X, (Object)owner);
            }
            return NLS.bind((String)Messages.TaskListToolTip_Assigned_to_X, (Object)Messages.TaskListToolTip_Unassigned);
        }
        return null;
    }

    private Image getOwnerImage(IRepositoryElement element) {
        if (element instanceof ITask) {
            ITask task = (ITask)element;
            if (!(element instanceof LocalTask)) {
                AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector(task.getConnectorKind());
                TaskRepository repository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
                if (StringUtils.isEmpty((CharSequence)task.getOwner())) {
                    return null;
                }
                if (connector.isOwnedByUser(repository, task)) {
                    return CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_ME);
                }
                return CommonImages.getImage((ImageDescriptor)CommonImages.PERSON);
            }
        }
        return null;
    }

    private String getExtendedToolTipText(IRepositoryElement element) {
        ITask task;
        String extendedToolTipInfo;
        if (element instanceof ITask && (extendedToolTipInfo = (task = (ITask)element).getAttribute("task.common.extended.tooltip")) != null && extendedToolTipInfo.length() > 0) {
            return extendedToolTipInfo;
        }
        return null;
    }

    private String getActivityText(IRepositoryElement element) {
        if (element instanceof AbstractTask) {
            DateRange scheduledDate;
            AbstractTask task = (AbstractTask)element;
            StringBuilder sb = new StringBuilder();
            Date dueDate = task.getDueDate();
            if (dueDate != null) {
                sb.append(NLS.bind((String)Messages.TaskListToolTip_Due, (Object[])new String[]{new SimpleDateFormat("E").format(dueDate), DateFormat.getDateInstance((int)1).format(dueDate), DateFormat.getTimeInstance((int)3).format(dueDate)}));
                sb.append("\n");
            }
            if ((scheduledDate = task.getScheduledForDate()) != null) {
                sb.append(NLS.bind((String)Messages.TaskListToolTip_Scheduled, (Object)scheduledDate.toString()));
                sb.append("\n");
            }
            long elapsed = TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)task);
            this.appendEstimateAndActive(sb, task.getEstimatedTimeHours(), elapsed);
            return sb.toString();
        }
        return null;
    }

    private String getIncomingText(IRepositoryElement element) {
        ITask task;
        String text = null;
        if (element instanceof ITask && (task = (ITask)element).getSynchronizationState().isIncoming() && StringUtils.isEmpty((CharSequence)(text = task.getAttribute("org.eclipse.mylyn.tasks.ui.TaskNotificationText")))) {
            TaskListNotifier notifier = new TaskListNotifier(TasksUiPlugin.getTaskDataManager(), TasksUiPlugin.getDefault().getSynchronizationManger());
            text = notifier.computeNotificationText(task);
        }
        return text;
    }

    private ImageDescriptor getIncomingImage() {
        ITask task;
        ImageDescriptor incomingImage = CommonImages.OVERLAY_SYNC_INCOMMING;
        IRepositoryElement iRepositoryElement = this.currentTipElement;
        if (iRepositoryElement instanceof ITask && (task = (ITask)iRepositoryElement).getSynchronizationState() == ITask.SynchronizationState.INCOMING_NEW) {
            incomingImage = CommonImages.OVERLAY_SYNC_INCOMMING_NEW;
        }
        return incomingImage;
    }

    private String getSynchronizationStateText(IRepositoryElement element) {
        Collection tasks;
        if (element instanceof ITaskContainer && (tasks = ((ITaskContainer)element).getChildren()).size() > 0) {
            int incoming = 0;
            int outgoing = 0;
            for (ITask task : tasks) {
                if (task.getSynchronizationState().isIncoming()) {
                    ++incoming;
                }
                if (!task.getSynchronizationState().isOutgoing()) continue;
                ++outgoing;
            }
            return NLS.bind((String)Messages.TaskListToolTip_Incoming_Outgoing, (Object[])new Object[]{incoming, outgoing});
        }
        return null;
    }

    private Image getStatusIcon(IRepositoryElement element) {
        if (element instanceof RepositoryQuery) {
            return CommonImages.getImage((ImageDescriptor)TasksUiInternal.getIconFromStatusOfQuery((RepositoryQuery)element));
        }
        return CommonImages.getImage((ImageDescriptor)CommonImages.WARNING);
    }

    private String getStatusText(IRepositoryElement element) {
        IStatus status = null;
        if (element instanceof AbstractTask) {
            AbstractTask task = (AbstractTask)element;
            status = task.getStatus();
        } else if (element instanceof IRepositoryQuery) {
            RepositoryQuery query = (RepositoryQuery)element;
            status = query.getStatus();
        }
        if (status != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(status.getMessage());
            if (status instanceof RepositoryStatus && ((RepositoryStatus)status).isHtmlMessage()) {
                sb.append(Messages.TaskListToolTip_Please_synchronize_manually_for_full_error_message);
            }
            return sb.toString();
        }
        return null;
    }

    public Point getLocation(Point tipSize, Event event) {
        Rectangle bounds;
        Widget widget = this.getTipWidget(event);
        if (widget != null && (bounds = this.getBounds(widget)) != null) {
            return this.control.toDisplay(bounds.x + X_SHIFT, bounds.y + bounds.height + 1);
        }
        return super.getLocation(tipSize, event);
    }

    private ProgressData getProgressData(IRepositoryElement element) {
        if (element instanceof ITaskContainer) {
            Object[] children = new Object[]{};
            children = ((ITaskContainer)element).getChildren().toArray();
            int total = children.length;
            if (total > 0) {
                int completed = 0;
                for (ITask task : ((ITaskContainer)element).getChildren()) {
                    if (!task.isCompleted()) continue;
                    ++completed;
                }
                String text = NLS.bind((String)Messages.TaskListToolTip_Total_Complete_Incomplete, (Object[])new Integer[]{total, completed, total - completed});
                return new ProgressData(completed, total, text);
            }
        }
        return null;
    }

    private Image getImage(IRepositoryElement element) {
        if (element instanceof IRepositoryQuery) {
            IRepositoryQuery query = (IRepositoryQuery)element;
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(query.getRepositoryUrl());
            if (repository != null) {
                return TasksUiPlugin.getDefault().getBrandManager().getBrandingIcon(repository);
            }
            return TasksUiPlugin.getDefault().getBrandManager().getDefaultBrandingIcon(query.getConnectorKind());
        }
        if (element instanceof ITask) {
            ITask task = (ITask)element;
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(task.getRepositoryUrl());
            if (repository != null) {
                return TasksUiPlugin.getDefault().getBrandManager().getBrandingIcon(repository);
            }
            return TasksUiPlugin.getDefault().getBrandManager().getDefaultBrandingIcon(task.getConnectorKind());
        }
        if (element instanceof ScheduledTaskContainer) {
            return CommonImages.getImage((ImageDescriptor)CommonImages.CALENDAR);
        }
        return null;
    }

    protected Widget getTipWidget(Event event) {
        Point widgetPosition = new Point(event.x, event.y);
        Widget widget = event.widget;
        if (widget instanceof ToolBar) {
            ToolBar w = (ToolBar)widget;
            return w.getItem(widgetPosition);
        }
        if (widget instanceof Table) {
            Table w = (Table)widget;
            return w.getItem(widgetPosition);
        }
        if (widget instanceof Tree) {
            Tree w = (Tree)widget;
            return w.getItem(widgetPosition);
        }
        return widget;
    }

    private Rectangle getBounds(Widget widget) {
        if (widget instanceof ToolItem) {
            ToolItem w = (ToolItem)widget;
            return w.getBounds();
        }
        if (widget instanceof TableItem) {
            TableItem w = (TableItem)widget;
            return w.getBounds();
        }
        if (widget instanceof TreeItem) {
            TreeItem w = (TreeItem)widget;
            return w.getBounds();
        }
        return null;
    }

    protected boolean shouldCreateToolTip(Event event) {
        Widget tipWidget;
        this.currentTipElement = null;
        if (this.isTriggeredByMouse() && !this.enabled) {
            return false;
        }
        if (super.shouldCreateToolTip(event) && (tipWidget = this.getTipWidget(event)) != null) {
            Rectangle bounds = this.getBounds(tipWidget);
            if (tipWidget instanceof ScalingHyperlink || bounds != null && this.contains(bounds.x, bounds.y)) {
                this.currentTipElement = this.getTaskListElement(tipWidget);
            }
        }
        if (this.currentTipElement == null) {
            this.hide();
            return false;
        }
        return true;
    }

    private boolean contains(int x, int y) {
        if (this.control instanceof Scrollable) {
            return ((Scrollable)this.control).getClientArea().contains(x, y);
        }
        return this.control.getBounds().contains(x, y);
    }

    protected Composite createToolTipArea(Event event, Composite parent) {
        String helpText;
        String statusText;
        ProgressData progress;
        String synchronizationStateText;
        String incomingText;
        String activityText;
        String synchText;
        String extendedText;
        String ownerText;
        assert (this.currentTipElement != null);
        Composite composite = this.createToolTipContentAreaComposite(parent);
        this.addIconAndLabel(composite, this.getImage(this.currentTipElement), this.getTitleText(this.currentTipElement), true);
        String detailsText = this.getDetailsText(this.currentTipElement);
        if (detailsText != null) {
            this.addIconAndLabel(composite, null, detailsText);
        }
        if ((ownerText = this.getOwnerText(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, this.getOwnerImage(this.currentTipElement), ownerText);
        }
        if ((extendedText = this.getExtendedToolTipText(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, null, extendedText);
        }
        if ((synchText = this.getSynchText(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, CommonImages.getImage((ImageDescriptor)TasksUiImages.REPOSITORY_SYNCHRONIZE), synchText);
        }
        if ((activityText = this.getActivityText(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, CommonImages.getImage((ImageDescriptor)CommonImages.CALENDAR), activityText);
        }
        if (!StringUtils.isEmpty((CharSequence)(incomingText = this.getIncomingText(this.currentTipElement)))) {
            ImageDescriptor incomingImage = this.getIncomingImage();
            this.addIconAndLabel(composite, CommonImages.getImage((ImageDescriptor)incomingImage), incomingText);
        }
        if ((synchronizationStateText = this.getSynchronizationStateText(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, null, synchronizationStateText);
        }
        if ((progress = this.getProgressData(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, null, progress.text);
            Label label = new Label(composite, 0);
            GridData labelGridData = new GridData(4, 128, true, false);
            labelGridData.heightHint = 0;
            label.setLayoutData((Object)labelGridData);
            Composite progressComposite = new Composite(composite, 0);
            GridLayout progressLayout = new GridLayout(1, false);
            progressLayout.marginWidth = 0;
            progressLayout.marginHeight = 0;
            progressComposite.setLayout((Layout)progressLayout);
            progressComposite.setLayoutData((Object)new GridData(4, 128, true, false));
            WorkweekProgressBar taskProgressBar = new WorkweekProgressBar(progressComposite);
            taskProgressBar.setLayoutData(new GridData(4, 128, true, false));
            taskProgressBar.reset(progress.completed, progress.total);
        }
        if ((statusText = this.getStatusText(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, this.getStatusIcon(this.currentTipElement), statusText);
        }
        if ((helpText = this.getHelpText(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, CommonImages.getImage((ImageDescriptor)CommonImages.QUESTION), helpText);
        }
        this.visible = true;
        return composite;
    }

    private String getHelpText(IRepositoryElement element) {
        TaskListView taskListView;
        if ((element instanceof TaskCategory || element instanceof IRepositoryQuery) && AbstractTaskListFilter.hasDescendantIncoming((ITaskContainer)element) && (taskListView = TaskListView.getFromActivePerspective()) != null && !taskListView.isFocusedMode() && TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.filters.complete")) {
            Object[] children = ((TaskListContentProvider)taskListView.getViewer().getContentProvider()).getChildren(element);
            boolean hasIncoming = false;
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof ITask && TasksUiInternal.shouldShowIncoming((ITask)child)) {
                    hasIncoming = true;
                    break;
                }
                ++n2;
            }
            if (!hasIncoming) {
                return Messages.TaskListToolTip_Some_incoming_elements_may_be_filtered;
            }
        }
        if (element instanceof UncategorizedTaskContainer) {
            return Messages.TaskListToolTip_Automatic_container_for_all_local_tasks;
        }
        if (element instanceof UnmatchedTaskContainer) {
            return Messages.TaskListToolTip_Automatic_container_for_repository_tasks;
        }
        return null;
    }

    protected Composite createToolTipContentAreaComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 2;
        composite.setLayout((Layout)gridLayout);
        composite.setBackground(composite.getDisplay().getSystemColor(29));
        return composite;
    }

    private String getSynchText(IRepositoryElement element) {
        String syncStamp;
        if (element instanceof IRepositoryQuery && (syncStamp = ((RepositoryQuery)element).getLastSynchronizedTimeStamp()) != null) {
            return NLS.bind((String)Messages.TaskListToolTip_Synchronized, (Object)syncStamp);
        }
        return null;
    }

    private String removeTrailingNewline(String text) {
        if (text.endsWith("\n")) {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }

    protected void addIconAndLabel(Composite parent, Image image, String text) {
        this.addIconAndLabel(parent, image, text, false);
    }

    protected void addIconAndLabel(Composite parent, Image image, String text, boolean title) {
        Label imageLabel = new Label(parent, 0);
        imageLabel.setForeground(parent.getDisplay().getSystemColor(28));
        imageLabel.setBackground(parent.getDisplay().getSystemColor(29));
        imageLabel.setLayoutData((Object)new GridData(34));
        imageLabel.setImage(image);
        Label textLabel = new Label(parent, 64);
        if (title) {
            textLabel.setFont(CommonFonts.BOLD);
        }
        textLabel.setForeground(this.titleColor);
        textLabel.setBackground(parent.getDisplay().getSystemColor(29));
        textLabel.setLayoutData((Object)new GridData(772));
        text = this.removeTrailingNewline(text);
        textLabel.setText(LegacyActionTools.escapeMnemonics((String)text));
        int width = Math.min(textLabel.computeSize((int)-1, (int)-1).x, 600);
        GridDataFactory.fillDefaults().align(4, 1).hint(width, -1).applyTo((Control)textLabel);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isTriggeredByMouse() {
        return this.triggeredByMouse;
    }

    public void show(Point location) {
        this.triggeredByMouse = false;
        super.show(location);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private static class ProgressData {
        int completed;
        int total;
        String text;

        public ProgressData(int completed, int total, String text) {
            this.completed = completed;
            this.total = total;
            this.text = text;
        }
    }

    public static interface TaskListToolTipListener {
        public void toolTipHidden(Event var1);
    }
}

