/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal;

import java.util.Objects;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class DrawableFigureUtilities {
    private final GC gc;
    private Font appliedFont;
    private FontMetrics metrics;

    public DrawableFigureUtilities(Control source) {
        this.gc = new GC((Drawable)source);
        source.addDisposeListener(e -> this.gc.dispose());
        this.appliedFont = this.gc.getFont();
    }

    public FontMetrics getFontMetrics(Font f) {
        this.setFont(f);
        if (this.metrics == null) {
            this.metrics = this.gc.getFontMetrics();
        }
        return this.metrics;
    }

    protected Point getTextDimension(String s, Font f) {
        this.setFont(f);
        return this.gc.textExtent(s);
    }

    protected Point getStringDimension(String s, Font f) {
        this.setFont(f);
        return this.gc.stringExtent(s);
    }

    public Dimension getTextExtents(String text, Font f) {
        return new Dimension(this.getTextDimension(text, f));
    }

    public Dimension getStringExtents(String s, Font f) {
        return new Dimension(this.getStringDimension(s, f));
    }

    public void getTextExtents(String s, Font f, Dimension result) {
        Point pt = this.getTextDimension(s, f);
        result.width = pt.x;
        result.height = pt.y;
    }

    public int getTextWidth(String s, Font f) {
        return this.getTextDimension((String)s, (Font)f).x;
    }

    private void setFont(Font f) {
        if (Objects.equals(this.appliedFont, f)) {
            return;
        }
        this.gc.setFont(f);
        this.appliedFont = f;
        this.metrics = null;
    }
}

