/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.eclipse.debug.internal.core.StreamDecoder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.internal.console.IOConsolePartitioner;

public class IOConsoleOutputStream
extends OutputStream {
    private volatile boolean closed;
    private IOConsolePartitioner partitioner;
    private final IOConsole console;
    private volatile boolean activateOnWrite;
    private volatile Color color;
    private volatile int fontStyle;
    private StreamDecoder decoder;
    private boolean prependCR;

    IOConsoleOutputStream(IOConsole console, Charset charset) {
        this.decoder = new StreamDecoder(charset);
        this.console = console;
        this.partitioner = (IOConsolePartitioner)console.getPartitioner();
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int newFontStyle) {
        if (newFontStyle != this.fontStyle) {
            int old = this.fontStyle;
            this.fontStyle = newFontStyle;
            this.console.firePropertyChange(this, IConsoleConstants.P_FONT_STYLE, old, this.fontStyle);
        }
    }

    public boolean isActivateOnWrite() {
        return this.activateOnWrite;
    }

    public void setActivateOnWrite(boolean activateOnWrite) {
        this.activateOnWrite = activateOnWrite;
    }

    public void setColor(Color newColor) {
        Color old = this.color;
        if (old == null || !old.equals((Object)newColor)) {
            this.color = newColor;
            this.console.firePropertyChange(this, IConsoleConstants.P_STREAM_COLOR, old, newColor);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close() throws IOException {
        String s;
        if (this.closed) {
            return;
        }
        if (this.prependCR) {
            this.prependCR = false;
            this.notifyParitioner("\r");
        }
        if ((s = this.decoder.finish()).length() > 0) {
            this.notifyParitioner(s);
        }
        this.console.streamClosed(this);
        this.closed = true;
        this.partitioner = null;
        this.decoder = null;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Output Stream is closed");
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Output Stream is closed");
        }
        String s = this.decoder.decode(b, off, len);
        this.encodedWrite(s);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(char[] buffer) throws IOException {
        String str = new String(buffer);
        this.encodedWrite(str);
    }

    public void write(char[] buffer, int off, int len) throws IOException {
        String str = new String(buffer, off, len);
        this.encodedWrite(str);
    }

    public void write(CharSequence chars) throws IOException {
        String str = chars.toString();
        this.encodedWrite(str);
    }

    public void write(String str) throws IOException {
        this.encodedWrite(str);
    }

    private synchronized void encodedWrite(String encodedString) throws IOException {
        if (this.closed) {
            throw new IOException("Output Stream is closed");
        }
        Object newencoding = encodedString;
        if (this.prependCR) {
            newencoding = "\r" + (String)newencoding;
            this.prependCR = false;
        }
        if (((String)newencoding).endsWith("\r")) {
            this.prependCR = true;
            newencoding = ((String)newencoding).substring(0, ((String)newencoding).length() - 1);
        }
        this.notifyParitioner((String)newencoding);
    }

    private void notifyParitioner(String encodedString) throws IOException {
        try {
            this.partitioner.streamAppended(this, encodedString);
            if (this.activateOnWrite) {
                this.console.activate();
            } else {
                ConsolePlugin.getDefault().getConsoleManager().warnOfContentChange(this.console);
            }
        }
        catch (IOException e) {
            if (!this.closed) {
                this.close();
            }
            throw e;
        }
    }

    public void setEncoding(String encoding) {
        String charsetName = encoding == null ? WorkbenchEncoding.getWorkbenchDefaultEncoding() : encoding;
        Charset charset = Charset.forName(charsetName);
        try {
            this.setCharset(charset);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void setCharset(Charset charset) throws IOException {
        if (this.closed) {
            throw new IOException("Output Stream is closed");
        }
        String s = this.decoder.finish();
        if (s.length() > 0) {
            this.encodedWrite(s);
        }
        this.decoder = new StreamDecoder(charset);
    }
}

