/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.dnd;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.dnd.AbstractContainerAreaDropAdapter;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetDndUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;

public class FileTransferDropTargetListener
extends AbstractContainerAreaDropAdapter {
    private final Viewer fViewer;

    public FileTransferDropTargetListener(Viewer viewer) {
        this.fViewer = viewer;
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    @Override
    public int dragEnterOperation(int operation) {
        return this.dragOverOperation(operation, null, null);
    }

    @Override
    public int dragOverOperation(int operation, IContainer dropContainer, Object dropTarget) {
        if (operation != 0) {
            return 1;
        }
        return operation;
    }

    @Override
    public void dropToContainer(Object dropObject, IContainer dropContainer, int operation) {
        if (dropObject instanceof String[] && ((String[])dropObject).length > 0 && dropContainer != null) {
            Shell shell = this.fViewer.getControl().getShell();
            FileTransferDropTargetListener.createFileTargetsUI((String[])dropObject, dropContainer, operation, shell);
        }
    }

    private static IMakeTarget[] prepareMakeTargetsFromFiles(String[] filenames, IContainer dropContainer, Shell shell) {
        ArrayList<IMakeTarget> makeTargetsList = new ArrayList<IMakeTarget>(filenames.length);
        int errorCount = 0;
        int nonFileCount = 0;
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String filepath = stringArray[n2];
            Path path = new Path(filepath);
            File file = path.toFile();
            if (file.isFile()) {
                String name = path.lastSegment();
                try {
                    String buildCommand = MakeTargetDndUtil.getProjectBuildCommand(dropContainer.getProject());
                    makeTargetsList.add(MakeTargetDndUtil.createMakeTarget(name, filepath, buildCommand, dropContainer));
                }
                catch (CoreException e) {
                    ++errorCount;
                    MakeUIPlugin.log(e);
                }
            } else {
                ++nonFileCount;
            }
            ++n2;
        }
        if (shell != null) {
            if (errorCount > 0) {
                MessageDialog.openError((Shell)shell, (String)MakeUIPlugin.getResourceString("MakeTargetDnD.title.createError"), (String)MakeUIPlugin.getResourceString("MakeTargetDnD.message.createError"));
            }
            if (nonFileCount > 0) {
                MessageDialog.openInformation((Shell)shell, (String)MakeUIPlugin.getResourceString("MakeTargetDnD.title.createInfo"), (String)MakeUIPlugin.getResourceString("MakeTargetDnD.message.createNonFileTargetAttempt"));
            }
        }
        return makeTargetsList.toArray(new IMakeTarget[makeTargetsList.size()]);
    }

    public static void createFileTargetsUI(String[] filenames, IContainer dropContainer, int operation, Shell shell) {
        IMakeTarget[] makeTargets = FileTransferDropTargetListener.prepareMakeTargetsFromFiles(filenames, dropContainer, shell);
        MakeTargetDndUtil.copyTargets(makeTargets, dropContainer, operation, shell);
    }
}

