/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring.code.flow;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;

public class Selection {
    public static final int INTERSECTS = 0;
    public static final int BEFORE = 1;
    public static final int SELECTED = 2;
    public static final int AFTER = 3;
    private int fStart;
    private int fLength;
    private int fEnd;

    protected Selection() {
    }

    public static Selection createFromStartLength(int start, int length) {
        Assert.isTrue((start >= 0 && length >= 0 ? 1 : 0) != 0);
        Selection result = new Selection();
        result.fStart = start;
        result.fLength = length;
        result.fEnd = start + length;
        return result;
    }

    public static Selection createFromStartEnd(int start, int end) {
        Assert.isTrue((start >= 0 && end >= start ? 1 : 0) != 0);
        Selection result = new Selection();
        result.fStart = start;
        result.fLength = end - start;
        result.fEnd = result.fStart + result.fLength;
        return result;
    }

    public int getOffset() {
        return this.fStart;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getEnd() {
        return this.fEnd;
    }

    public int getVisitSelectionMode(IASTNode node) {
        IASTFileLocation location = node.getFileLocation();
        int nodeStart = location.getNodeOffset();
        int nodeEnd = nodeStart + location.getNodeLength();
        if (nodeEnd <= this.fStart) {
            return 1;
        }
        if (this.covers(node)) {
            return 2;
        }
        if (this.fEnd <= nodeStart) {
            return 3;
        }
        return 0;
    }

    public int getLeaveSelectionMode(IASTNode node) {
        IASTFileLocation location = node.getFileLocation();
        int nodeStart = location.getNodeOffset();
        int nodeEnd = nodeStart + location.getNodeLength();
        if (nodeEnd <= this.fStart) {
            return 1;
        }
        if (this.covers(node)) {
            return 2;
        }
        if (this.fEnd <= nodeEnd) {
            return 3;
        }
        return 0;
    }

    public boolean covers(int position) {
        return this.fStart <= position && position < this.fStart + this.fLength;
    }

    public boolean covers(IASTNode node) {
        IASTFileLocation location = node.getFileLocation();
        int nodeStart = location.getNodeOffset();
        return this.fStart <= nodeStart && nodeStart + location.getNodeLength() <= this.fEnd;
    }

    public boolean coveredBy(IASTNode node) {
        IASTFileLocation location = node.getFileLocation();
        int nodeStart = location.getNodeOffset();
        return nodeStart <= this.fStart && this.fEnd <= nodeStart + location.getNodeLength();
    }

    public boolean coveredBy(IRegion region) {
        int regionStart = region.getOffset();
        return regionStart <= this.fStart && this.fEnd <= regionStart + region.getLength();
    }

    public boolean endsIn(IASTNode node) {
        IASTFileLocation location = node.getFileLocation();
        int nodeStart = location.getNodeOffset();
        return nodeStart < this.fEnd && this.fEnd < nodeStart + location.getNodeLength();
    }

    public boolean liesOutside(IASTNode node) {
        IASTFileLocation location = node.getFileLocation();
        int nodeStart = location.getNodeOffset();
        return this.fEnd < nodeStart || nodeStart + location.getNodeLength() < this.fStart;
    }

    public String toString() {
        return "<start == " + this.fStart + ", length == " + this.fLength + "/>";
    }
}

