/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs;

import org.eclipse.cdt.internal.ui.dialogs.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class FormattingScopeDialog
extends StatusDialog {
    private Button fDoNotAskAgainCheckBox;
    private Button fScopeFileRadio;
    private Button fScopeStatementRadio;
    private IPreferenceStore preferenceStore;

    public FormattingScopeDialog(Shell shell) {
        super(shell);
        this.setTitle(Messages.FormattingScopeDialog_title);
        this.setHelpAvailable(false);
        this.preferenceStore = CUIPlugin.getDefault().getPreferenceStore();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        PixelConverter converter = new PixelConverter((Control)composite);
        this.createLabel(composite, Messages.FormattingScopeDialog_message);
        int indent = converter.convertHorizontalDLUsToPixels(8);
        this.fScopeFileRadio = this.createRadioButton(composite, Messages.FormattingScopeDialog_format_file, indent);
        this.fScopeStatementRadio = this.createRadioButton(composite, Messages.FormattingScopeDialog_format_statement, indent);
        this.createLabel(composite, "");
        this.fDoNotAskAgainCheckBox = this.createCheckBox(composite, Messages.FormattingScopeDialog_do_not_ask_again);
        String scope = this.preferenceStore.getString("formattingScopeForEmptySelection");
        if ("document".equals(scope)) {
            this.fScopeFileRadio.setSelection(true);
        } else {
            this.fScopeStatementRadio.setSelection(true);
        }
        FormattingScopeDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        String scope = this.fScopeFileRadio.getSelection() ? "document" : "statement";
        this.preferenceStore.setValue("formattingScopeForEmptySelection", scope);
        if (this.fDoNotAskAgainCheckBox.getSelection()) {
            this.preferenceStore.setValue("formattingConfirmScopeForEmptySelection", false);
        }
        super.okPressed();
    }

    private Button createRadioButton(Composite container, String text, int indent) {
        return this.createButton(16, container, text, indent);
    }

    private Button createCheckBox(Composite container, String text) {
        return this.createButton(32, container, text, 0);
    }

    private Button createButton(int style, Composite container, String text, int indent) {
        Button button = new Button(container, style);
        GridData layoutData = new GridData();
        layoutData.horizontalIndent = indent;
        button.setLayoutData((Object)layoutData);
        button.setText(text);
        return button;
    }

    private Label createLabel(Composite container, String text) {
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(text);
        return label;
    }
}

