/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.cdt.internal.ui.editor.CElementIncludeResolver;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.MessageBox;

public class OpenIncludeAction
extends Action {
    private static final String PREFIX = "OpenIncludeAction.";
    private static final String DIALOG_TITLE = "OpenIncludeAction.dialog.title";
    private static final String DIALOG_MESSAGE = "OpenIncludeAction.dialog.message";
    private ISelectionProvider fSelectionProvider;

    public OpenIncludeAction(ISelectionProvider provider) {
        super(CUIPlugin.getResourceString("OpenIncludeAction.label"));
        this.setDescription(CUIPlugin.getResourceString("OpenIncludeAction.description"));
        this.setToolTipText(CUIPlugin.getResourceString("OpenIncludeAction.tooltip"));
        CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.cdt.ui.open_include.gif");
        this.fSelectionProvider = provider;
    }

    public void run() {
        IInclude include = OpenIncludeAction.getIncludeStatement(this.fSelectionProvider.getSelection());
        if (include == null) {
            return;
        }
        try {
            List<IPath> filesFound = CElementIncludeResolver.resolveInclude(include);
            int nElementsFound = filesFound.size();
            if (nElementsFound == 0) {
                OpenIncludeAction.noElementsFound();
                return;
            }
            IPath fileToOpen = nElementsFound == 1 ? filesFound.get(0) : OpenIncludeAction.chooseFile(filesFound);
            if (fileToOpen != null) {
                EditorUtility.openInEditor(fileToOpen, (ICElement)include);
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e.getStatus());
        }
    }

    private static void noElementsFound() {
        MessageBox errorMsg = new MessageBox(CUIPlugin.getActiveWorkbenchShell(), 33);
        errorMsg.setText(CUIPlugin.getResourceString("OpenIncludeAction.error"));
        errorMsg.setMessage(CUIPlugin.getResourceString("OpenIncludeAction.error.description"));
        errorMsg.open();
    }

    private static IPath chooseFile(List<IPath> filesFound) {
        return OpenActionUtil.selectPath(filesFound, CUIPlugin.getResourceString(DIALOG_TITLE), CUIPlugin.getResourceString(DIALOG_MESSAGE));
    }

    private static IInclude getIncludeStatement(ISelection sel) {
        Object element;
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() == 1 && (element = list.get(0)) instanceof IInclude) {
            return (IInclude)element;
        }
        return null;
    }

    public static boolean canActionBeAdded(ISelection selection) {
        IResource res;
        IInclude include = OpenIncludeAction.getIncludeStatement(selection);
        return include != null && (res = include.getUnderlyingResource()) != null;
    }
}

