/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.CustomBufferFactory;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.IWorkingCopyManagerExtension;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;

public class WorkingCopyManager
implements IWorkingCopyManager,
IWorkingCopyManagerExtension {
    private CDocumentProvider fDocumentProvider;
    private Map<IEditorInput, IWorkingCopy> fMap;
    private boolean fIsShuttingDown;
    private IBufferFactory fBufferFactory;

    public WorkingCopyManager(CDocumentProvider provider) {
        Assert.isNotNull((Object)((Object)provider));
        this.fDocumentProvider = provider;
    }

    @Override
    public void connect(IEditorInput input) throws CoreException {
        this.fDocumentProvider.connect(input);
    }

    @Override
    public void disconnect(IEditorInput input) {
        this.fDocumentProvider.disconnect(input);
    }

    @Override
    public void shutdown() {
        if (!this.fIsShuttingDown) {
            this.fIsShuttingDown = true;
            try {
                if (this.fMap != null) {
                    this.fMap.clear();
                    this.fMap = null;
                }
                this.fDocumentProvider.shutdown();
            }
            finally {
                this.fIsShuttingDown = false;
            }
        }
    }

    @Override
    public IWorkingCopy getWorkingCopy(IEditorInput input) {
        IWorkingCopy unit = this.fMap == null ? null : this.fMap.get(input);
        return unit != null ? unit : this.fDocumentProvider.getWorkingCopy(input);
    }

    @Override
    public void setWorkingCopy(IEditorInput input, IWorkingCopy workingCopy) {
        if (this.fDocumentProvider.getDocument(input) != null) {
            if (this.fMap == null) {
                this.fMap = new HashMap<IEditorInput, IWorkingCopy>();
            }
            this.fMap.put(input, workingCopy);
        }
    }

    @Override
    public void removeWorkingCopy(IEditorInput input) {
        this.fMap.remove(input);
        if (this.fMap.isEmpty()) {
            this.fMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBufferFactory getBufferFactory() {
        if (this.fBufferFactory == null) {
            WorkingCopyManager workingCopyManager = this;
            synchronized (workingCopyManager) {
                if (this.fBufferFactory == null) {
                    this.fBufferFactory = new CustomBufferFactory();
                }
            }
        }
        return this.fBufferFactory;
    }

    @Override
    public IWorkingCopy findSharedWorkingCopy(ITranslationUnit tu) {
        return CModelManager.getDefault().findSharedWorkingCopy(this.getBufferFactory(), tu);
    }

    @Override
    public IWorkingCopy[] getSharedWorkingCopies() {
        return CModelManager.getDefault().getSharedWorkingCopies(this.getBufferFactory());
    }

    @Override
    public IWorkingCopy getSharedWorkingCopy(ITranslationUnit original, IProblemRequestor requestor, IProgressMonitor progressMonitor) throws CModelException {
        return CModelManager.getDefault().getSharedWorkingCopy(this.getBufferFactory(), original, requestor, progressMonitor);
    }
}

