/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.includebrowser;

import java.util.Objects;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.includebrowser.IBFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;

public class IBNode
implements IAdaptable {
    private IBNode fParent;
    private IBFile fRepresentedFile;
    private IBFile fDirectiveFile;
    private int fDirectiveCharacterOffset;
    private int fDirectiveLength;
    private int fHashCode;
    private boolean fIsSystemInclude = false;
    private boolean fIsActive = true;
    private boolean fIsRecursive;
    private long fTimestamp;

    public IBNode(IBNode parent, IBFile represents, IBFile fileOfDirective, int charOffset, int length, long timestamp) {
        assert (represents != null);
        this.fParent = parent;
        this.fRepresentedFile = represents;
        this.fDirectiveFile = fileOfDirective;
        this.fDirectiveCharacterOffset = charOffset;
        this.fDirectiveLength = length;
        this.fIsRecursive = this.computeIsRecursive(this.fParent, represents.getLocation());
        this.fHashCode = this.computeHashCode();
        this.fTimestamp = timestamp;
    }

    private int computeHashCode() {
        int hashCode = 0;
        if (this.fParent != null) {
            hashCode = this.fParent.hashCode() * 31;
        }
        return hashCode += this.fRepresentedFile.hashCode();
    }

    public int hashCode() {
        return this.fHashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IBNode)) {
            return false;
        }
        IBNode rhs = (IBNode)o;
        if (this.fHashCode != rhs.fHashCode) {
            return false;
        }
        return Objects.equals(this.fRepresentedFile, rhs.fRepresentedFile);
    }

    private boolean computeIsRecursive(IBNode parent, IIndexFileLocation ifl) {
        if (parent == null || ifl == null) {
            return false;
        }
        if (ifl.equals(parent.getRepresentedFile().getLocation())) {
            return true;
        }
        return this.computeIsRecursive(parent.fParent, ifl);
    }

    public IBNode getParent() {
        return this.fParent;
    }

    public IBFile getRepresentedFile() {
        return this.fRepresentedFile;
    }

    public boolean isSystemInclude() {
        return this.fIsSystemInclude;
    }

    public void setIsSystemInclude(boolean isSystemInclude) {
        this.fIsSystemInclude = isSystemInclude;
    }

    public boolean isActiveCode() {
        return this.fIsActive;
    }

    public void setIsActiveCode(boolean isActiveCode) {
        this.fIsActive = isActiveCode;
    }

    public boolean isRecursive() {
        return this.fIsRecursive;
    }

    public int getDirectiveCharacterOffset() {
        return this.fDirectiveCharacterOffset;
    }

    public int getDirectiveLength() {
        return this.fDirectiveLength;
    }

    public IBFile getDirectiveFile() {
        return this.fDirectiveFile;
    }

    public String getDirectiveName() {
        return this.fRepresentedFile.getName();
    }

    public Object getAdapter(Class adapter) {
        if (this.fRepresentedFile != null) {
            if (adapter.isAssignableFrom(ITranslationUnit.class)) {
                return this.fRepresentedFile.getTranslationUnit();
            }
            if (adapter.isAssignableFrom(IFile.class)) {
                return this.fRepresentedFile.getResource();
            }
            if (adapter.isAssignableFrom(IIndexFileLocation.class)) {
                return this.fRepresentedFile.getLocation();
            }
        }
        return null;
    }

    public ITranslationUnit getRepresentedTranslationUnit() {
        return this.fRepresentedFile == null ? null : this.fRepresentedFile.getTranslationUnit();
    }

    public IPath getRepresentedPath() {
        if (this.fRepresentedFile == null) {
            return null;
        }
        IIndexFileLocation ifl = this.fRepresentedFile.getLocation();
        if (ifl != null) {
            return IndexLocationFactory.getPath((IIndexFileLocation)ifl);
        }
        return null;
    }

    public IIndexFileLocation getRepresentedIFL() {
        return this.fRepresentedFile == null ? null : this.fRepresentedFile.getLocation();
    }

    public long getTimestamp() {
        return this.fTimestamp;
    }

    public ICProject getCProject() {
        ITranslationUnit tu = this.getRepresentedTranslationUnit();
        if (tu != null) {
            return tu.getCProject();
        }
        IBNode parent = this.getParent();
        if (parent != null) {
            return parent.getCProject();
        }
        return null;
    }
}

