/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.AccessorDescriptor;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.FieldDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class GetterSetterContext
implements ITreeContentProvider {
    final List<IASTDeclarator> existingFields = new ArrayList<IASTDeclarator>();
    final List<IASTFunctionDefinition> existingFunctionDefinitions = new ArrayList<IASTFunctionDefinition>();
    final List<IASTSimpleDeclaration> existingFunctionDeclarations = new ArrayList<IASTSimpleDeclaration>();
    final SortedSet<AccessorDescriptor> selectedAccessors = new TreeSet<AccessorDescriptor>();
    IASTName selectedName;
    private List<FieldDescriptor> fieldDescriptors;
    private boolean definitionSeparate;
    private static final Object[] NO_CHILDREN = new Object[0];

    public Object[] getChildren(Object parentElement) {
        if (!(parentElement instanceof FieldDescriptor)) {
            return NO_CHILDREN;
        }
        return ((FieldDescriptor)parentElement).getChildNodes();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof FieldDescriptor) {
            FieldDescriptor descriptor = (FieldDescriptor)element;
            return descriptor.missingGetterOrSetter();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getFieldDescriptors().toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void recreateFieldDescriptors() {
        this.fieldDescriptors = null;
        TreeSet<AccessorDescriptor> oldSelected = new TreeSet<AccessorDescriptor>(this.selectedAccessors);
        this.selectedAccessors.clear();
        for (FieldDescriptor descriptor : this.getFieldDescriptors()) {
            AccessorDescriptor[] accessorDescriptorArray = descriptor.getChildNodes();
            int n = accessorDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                AccessorDescriptor accessor = accessorDescriptorArray[n2];
                if (oldSelected.contains(accessor)) {
                    this.selectedAccessors.add(accessor);
                }
                ++n2;
            }
        }
    }

    public void selectAccessorForField(String name, AccessorDescriptor.AccessorKind kind) {
        block0: for (FieldDescriptor descriptor : this.getFieldDescriptors()) {
            if (!name.equals(String.valueOf(descriptor.getFieldName().getSimpleID()))) continue;
            AccessorDescriptor[] accessorDescriptorArray = descriptor.getChildNodes();
            int n = accessorDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                AccessorDescriptor child = accessorDescriptorArray[n2];
                AccessorDescriptor accessor = child;
                if (accessor.getKind() == kind) {
                    this.selectedAccessors.add(accessor);
                    continue block0;
                }
                ++n2;
            }
        }
    }

    public boolean isDefinitionSeparate() {
        return this.definitionSeparate;
    }

    public void setDefinitionSeparate(boolean definitionSeparate) {
        this.definitionSeparate = definitionSeparate;
    }

    private List<FieldDescriptor> getFieldDescriptors() {
        if (this.fieldDescriptors == null) {
            this.fieldDescriptors = new ArrayList<FieldDescriptor>();
            for (IASTDeclarator field : this.existingFields) {
                FieldDescriptor descriptor = new FieldDescriptor(field, this);
                if (!descriptor.missingGetterOrSetter()) continue;
                this.fieldDescriptors.add(descriptor);
            }
        }
        return this.fieldDescriptors;
    }

    static IASTName getDeclaratorName(IASTDeclarator declarator) {
        while (declarator.getNestedDeclarator() != null) {
            declarator = declarator.getNestedDeclarator();
        }
        return declarator.getName();
    }

    static IASTName getDeclarationName(IASTSimpleDeclaration declaration) {
        return GetterSetterContext.getDeclaratorName(declaration.getDeclarators()[0]);
    }
}

