/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.parser.util.StringUtil;
import org.eclipse.core.runtime.IPath;

class InclusionRequest {
    private static final String UNINITIALIZED = "uninitialized";
    private final IBinding fBinding;
    private final Map<IIndexFile, IPath> fDeclaringFiles;
    private final boolean fReachable;
    private List<IPath> fCandidatePaths;
    private IPath fResolvedPath;
    private String fQualifiedName = "uninitialized";

    public InclusionRequest(IBinding binding, Map<IIndexFile, IPath> declaringHeaders, boolean reachable) {
        this.fBinding = binding;
        this.fDeclaringFiles = Collections.unmodifiableMap(declaringHeaders);
        this.fReachable = reachable;
        this.fCandidatePaths = new ArrayList<IPath>(new HashSet<IPath>(this.fDeclaringFiles.values()));
    }

    public IBinding getBinding() {
        return this.fBinding;
    }

    public String getBindingQualifiedName() {
        if (this.fQualifiedName == UNINITIALIZED) {
            this.fQualifiedName = null;
            if (this.fBinding instanceof ICPPBinding) {
                ICPPBinding cppBinding = (ICPPBinding)this.fBinding;
                try {
                    if (cppBinding.isGloballyQualified()) {
                        this.fQualifiedName = StringUtil.join((String[])cppBinding.getQualifiedName(), (String)"::");
                    }
                }
                catch (DOMException dOMException) {}
            } else if (this.fBinding instanceof IMacroBinding || this.fBinding.getOwner() == null) {
                this.fQualifiedName = this.fBinding.getName();
            }
        }
        return this.fQualifiedName;
    }

    public Map<IIndexFile, IPath> getDeclaringFiles() {
        return this.fDeclaringFiles;
    }

    public List<IPath> getCandidatePaths() {
        return this.fCandidatePaths;
    }

    public void setCandidatePaths(List<IPath> paths) {
        this.fCandidatePaths = paths;
    }

    public boolean isReachable() {
        return this.fReachable;
    }

    public void resolve(IPath path) {
        if (this.fResolvedPath != null) {
            throw new IllegalStateException();
        }
        this.fResolvedPath = path;
    }

    public IPath getResolvedPath() {
        return this.fResolvedPath;
    }

    public boolean isResolved() {
        return this.fResolvedPath != null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.fBinding.getName());
        buf.append(" defined in ");
        int i = 0;
        while (i < this.fCandidatePaths.size()) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.fCandidatePaths.get(i).toOSString());
            ++i;
        }
        if (this.fResolvedPath != null) {
            buf.append(" represented by ");
            buf.append(this.fResolvedPath.toOSString());
        }
        return buf.toString();
    }
}

