/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.internal.ui.text.FastCPartitionScanner;
import org.eclipse.cdt.internal.ui.text.FastCPartitioner;
import org.eclipse.cdt.internal.ui.text.doctools.DocCommentOwnerManager;
import org.eclipse.cdt.internal.ui.text.util.CColorManager;
import org.eclipse.cdt.ui.text.ICPartitions;
import org.eclipse.cdt.ui.text.IColorManager;
import org.eclipse.cdt.ui.text.doctools.IDocCommentOwner;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class CTextTools {
    private CColorManager fColorManager = new CColorManager(true);
    private String fDocumentPartitioning = "___c_partitioning";

    public void dispose() {
        if (this.fColorManager != null) {
            this.fColorManager.dispose();
            this.fColorManager = null;
        }
    }

    public IColorManager getColorManager() {
        return this.fColorManager;
    }

    public IPartitionTokenScanner getPartitionScanner(IDocCommentOwner owner) {
        return new FastCPartitionScanner(owner);
    }

    public IDocumentPartitioner createDocumentPartitioner(IDocCommentOwner owner) {
        return new FastCPartitioner(this.getPartitionScanner(owner), ICPartitions.ALL_CPARTITIONS);
    }

    public void setupCDocumentPartitioner(IDocument document, String partitioning, IDocCommentOwner owner) {
        IDocumentPartitioner partitioner = this.createDocumentPartitioner(owner);
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            extension3.setDocumentPartitioner(partitioning, partitioner);
        } else {
            document.setDocumentPartitioner(partitioner);
        }
        partitioner.connect(document);
    }

    public void setupCDocument(IDocument document, IPath location, LocationKind locationKind) {
        IDocCommentOwner owner = this.getDocumentationCommentOwner(location, locationKind);
        this.setupCDocumentPartitioner(document, this.fDocumentPartitioning, owner);
    }

    public void setupCDocument(IDocument document) {
        this.setupCDocumentPartitioner(document, this.fDocumentPartitioning, null);
    }

    public String getDocumentPartitioning() {
        return this.fDocumentPartitioning;
    }

    public void setDocumentPartitioning(String documentPartitioning) {
        this.fDocumentPartitioning = documentPartitioning;
    }

    private IDocCommentOwner getDocumentationCommentOwner(IPath location, LocationKind locationKind) {
        if (location != null && LocationKind.IFILE.equals(locationKind)) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(location);
            return DocCommentOwnerManager.getInstance().getCommentOwner((IResource)file);
        }
        return DocCommentOwnerManager.getInstance().getWorkspaceCommentOwner();
    }
}

