/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.uitree;

import java.util.List;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.core.templateengine.TemplateEngineUtil;
import org.eclipse.cdt.ui.templateengine.SimpleElementException;
import org.eclipse.cdt.ui.templateengine.uitree.GenericUIElementGroup;
import org.eclipse.cdt.ui.templateengine.uitree.IUIElementTreeBuilderManager;
import org.eclipse.cdt.ui.templateengine.uitree.UIElement;
import org.eclipse.cdt.ui.templateengine.uitree.UIElementTreeBuilderHelper;
import org.w3c.dom.Element;

public class UIElementTreeBuilderManager
implements IUIElementTreeBuilderManager {
    private UIElementTreeBuilderHelper uiElementTreeBuilderHelper;
    private UIElement uiTreeRoot = null;

    public UIElementTreeBuilderManager(UIElementTreeBuilderHelper uiElementTreeBuilderHelper) {
        this.uiElementTreeBuilderHelper = uiElementTreeBuilderHelper;
    }

    @Override
    public void createUIElementTree(UIElement uiParent, Element element) {
        if (uiParent == null) {
            uiParent = this.uiTreeRoot = this.uiElementTreeBuilderHelper.getUIElement(element);
        }
        if (uiParent != null && uiParent instanceof GenericUIElementGroup) {
            List childList = TemplateEngine.getChildrenOfElement((Element)element);
            int listIndex = 0;
            int l = childList.size();
            while (listIndex < l) {
                UIElement uiElement = this.uiElementTreeBuilderHelper.getUIElement((Element)childList.get(listIndex));
                if (uiElement != null) {
                    uiElement.setParent(uiParent);
                    try {
                        uiParent.addToChildList(uiElement);
                    }
                    catch (SimpleElementException exp) {
                        TemplateEngineUtil.log((Throwable)exp);
                    }
                    this.createUIElementTree(uiElement, (Element)childList.get(listIndex));
                }
                ++listIndex;
            }
        }
    }

    public UIElement getUIElementTreeRoot() {
        return this.uiTreeRoot;
    }

    public void setUIElementTreeRootNull() {
        this.uiTreeRoot = null;
    }
}

