/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.text;

import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;

public abstract class SharedASTJob
extends Job {
    protected final ITranslationUnit fUnit;

    public SharedASTJob(String name, ITranslationUnit tUnit) {
        super(name);
        this.fUnit = tUnit;
    }

    public abstract IStatus runOnAST(ILanguage var1, IASTTranslationUnit var2) throws CoreException;

    protected final IStatus run(IProgressMonitor monitor) {
        ASTProvider provider = CUIPlugin.getDefault().getASTProvider();
        if (provider == null) {
            return Status.CANCEL_STATUS;
        }
        return provider.runOnAST((ICElement)this.fUnit, ASTProvider.WAIT_ACTIVE_ONLY, monitor, new ASTCache.ASTRunnable(){

            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
                return SharedASTJob.this.runOnAST(lang, ast);
            }
        });
    }

    public boolean shouldSchedule() {
        return super.shouldSchedule() && PlatformUI.isWorkbenchRunning() && CUIPlugin.getDefault() != null;
    }

    public boolean shouldRun() {
        return super.shouldRun() && PlatformUI.isWorkbenchRunning() && CUIPlugin.getDefault() != null;
    }
}

