/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.validation;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.BindingMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ObjectToPrimitiveValidator
implements IValidator<Object> {
    private final Class<?> toType;
    private final Class<?>[][] primitiveMap = new Class[][]{{Integer.TYPE, Integer.class}, {Short.TYPE, Short.class}, {Long.TYPE, Long.class}, {Double.TYPE, Double.class}, {Byte.TYPE, Byte.class}, {Float.TYPE, Float.class}, {Boolean.TYPE, Boolean.class}, {Character.TYPE, Character.class}};

    public ObjectToPrimitiveValidator(Class<?> toType) {
        this.toType = toType;
    }

    protected Class<?> getToType() {
        return this.toType;
    }

    @Override
    public IStatus validate(Object value) {
        return this.doValidate(value);
    }

    private IStatus doValidate(Object value) {
        if (value != null) {
            if (!this.mapContainsValues(this.toType, value.getClass())) {
                return ValidationStatus.error(this.getClassHint());
            }
            return Status.OK_STATUS;
        }
        return ValidationStatus.error(this.getNullHint());
    }

    private boolean mapContainsValues(Class<?> toType, Class<?> fromType) {
        Class<?>[][] classArray = this.primitiveMap;
        int n = this.primitiveMap.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] primitiveTuple = classArray[n2];
            if (primitiveTuple[0].equals(toType) && primitiveTuple[1].equals(fromType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getNullHint() {
        return BindingMessages.getString("Validate_ConversionToPrimitive");
    }

    public String getClassHint() {
        return BindingMessages.getString("Validate_ConversionFromClassToPrimitive");
    }
}

