/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import java.util.function.Consumer;

@FunctionalInterface
public interface ConsumerWithException<T, E extends Exception> {
    public void accept(T var1) throws E;

    public static <T, E extends Exception> Consumer<T> consumer(ConsumerWithException<T, E> consumerWithException, Class<E> exceptionClass, Consumer<E> exceptionHandler) {
        return t -> {
            try {
                consumerWithException.accept(t);
            }
            catch (Exception ex) {
                try {
                    if (exceptionHandler != null) {
                        Exception exCast = (Exception)exceptionClass.cast(ex);
                        exceptionHandler.accept(exCast);
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                throw new RuntimeException(ex);
            }
        };
    }

    public static <T, E extends Exception> Consumer<T> consumer(ConsumerWithException<T, E> consumerWithException) {
        return ConsumerWithException.consumer(consumerWithException, null, null);
    }
}

