/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.cache;

import org.eclipse.net4j.util.cache.ICacheMonitor;
import org.eclipse.net4j.util.cache.ThresholdConditionPolicy;

public class HysteresisConditionPolicy
extends ThresholdConditionPolicy {
    private long thresholdYellowRed;
    private long thresholdGreenYellow;

    public HysteresisConditionPolicy(long thresholdYellowRed, long thresholdRedYellow, long thresholdGreenYellow, long thresholdYellowGreen) {
        super(thresholdRedYellow, thresholdYellowGreen);
        if (thresholdYellowRed > thresholdRedYellow) {
            throw new IllegalArgumentException("thresholdYellowRed > thresholdRedYellow");
        }
        if (thresholdRedYellow > thresholdGreenYellow) {
            throw new IllegalArgumentException("thresholdRedYellow > thresholdGreenYellow");
        }
        if (thresholdGreenYellow > thresholdYellowGreen) {
            throw new IllegalArgumentException("thresholdGreenYellow > thresholdYellowGreen");
        }
        this.thresholdGreenYellow = thresholdGreenYellow;
        this.thresholdYellowRed = thresholdYellowRed;
    }

    public long getThresholdYellowRed() {
        return this.thresholdYellowRed;
    }

    public long getThresholdGreenYellow() {
        return this.thresholdGreenYellow;
    }

    @Override
    protected ICacheMonitor.Condition getNewCondition(ICacheMonitor.Condition oldCondition, long freeMemory) {
        switch (oldCondition) {
            case GREEN: {
                if (freeMemory < this.thresholdYellowRed) {
                    return ICacheMonitor.Condition.RED;
                }
                if (freeMemory < this.thresholdGreenYellow) {
                    return ICacheMonitor.Condition.YELLOW;
                }
                return ICacheMonitor.Condition.GREEN;
            }
            case YELLOW: {
                if (freeMemory < this.thresholdYellowRed) {
                    return ICacheMonitor.Condition.RED;
                }
                if (freeMemory > this.getThresholdYellowGreen()) {
                    return ICacheMonitor.Condition.GREEN;
                }
                return ICacheMonitor.Condition.YELLOW;
            }
            case RED: {
                if (freeMemory > this.getThresholdYellowGreen()) {
                    return ICacheMonitor.Condition.GREEN;
                }
                if (freeMemory > this.getThresholdRedYellow()) {
                    return ICacheMonitor.Condition.YELLOW;
                }
                return ICacheMonitor.Condition.RED;
            }
        }
        throw new IllegalArgumentException("oldCondition == " + (Object)((Object)oldCondition));
    }
}

