/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.routers;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.OrthogonalConnectionAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ObliqueRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouterUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.RouterHelper;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class RectilinearRouter
extends ObliqueRouter
implements OrthogonalRouter {
    private static int maxNestedRoutingDepth = 1;

    @Override
    protected boolean checkSelfRelConnection(Connection conn, PointList newLine) {
        boolean selfConn = super.checkSelfRelConnection(conn, newLine);
        if (selfConn) {
            newLine.removePoint(0);
            newLine.removePoint(newLine.size() - 1);
        }
        return selfConn;
    }

    @Override
    public void routeLine(Connection conn, int nestedRoutingDepth, PointList newLine) {
        Ray middleSeg;
        boolean skipNormalization;
        boolean bl = skipNormalization = (this.routerFlags & 1) != 0;
        if (this.isReorienting(conn)) {
            super.routeLine(conn, nestedRoutingDepth, newLine);
            return;
        }
        if (this.checkSelfRelConnection(conn, newLine) || this.checkShapesIntersect(conn, newLine)) {
            this.resetEndPointsToEdge(conn, newLine);
            OrthogonalRouterUtilities.transformToOrthogonalPointList(newLine, this.getOffShapeDirection(this.getAnchorOffRectangleDirection(newLine.getFirstPoint(), (Rectangle)this.sourceBoundsRelativeToConnection(conn))), this.getOffShapeDirection(this.getAnchorOffRectangleDirection(newLine.getLastPoint(), (Rectangle)this.targetBoundsRelativeToConnection(conn))));
            this.removeRedundantPoints(newLine);
            return;
        }
        if (conn.getSourceAnchor().getOwner() == conn.getTargetAnchor().getOwner()) {
            nestedRoutingDepth = maxNestedRoutingDepth;
        }
        Point lastStartAnchor = newLine.removePoint(0);
        Point lastEndAnchor = newLine.removePoint(newLine.size() - 1);
        if (!OrthogonalRouterUtilities.isRectilinear(newLine)) {
            OrthogonalRouterUtilities.transformToOrthogonalPointList(newLine, 0, 0);
        }
        this.removeRedundantPoints(newLine);
        this.removePointsInViews(conn, newLine, lastStartAnchor, lastEndAnchor);
        Dimension tolerance = new Dimension(3, 0);
        if (!RouterHelper.getInstance().isFeedback(conn)) {
            tolerance = (Dimension)MapModeUtil.getMapMode((IFigure)conn).DPtoLP((Translatable)tolerance);
        }
        if (!skipNormalization && PointListUtilities.normalizeSegments(newLine, tolerance.width)) {
            this.normalizeToStraightLineTolerance(newLine, tolerance.width);
        }
        if (newLine.size() == 2 && (middleSeg = new Ray(newLine.getFirstPoint(), newLine.getLastPoint())).length() <= (double)tolerance.width) {
            newLine.removePoint(0);
        }
        this.resetEndPointsToEdge(conn, newLine);
        if (nestedRoutingDepth < maxNestedRoutingDepth && !this.isValidRectilinearLine(conn, newLine)) {
            this.routeLine(conn, ++nestedRoutingDepth, newLine);
        }
    }

    private boolean isValidRectilinearLine(Connection conn, PointList line) {
        if (!(conn.getSourceAnchor().getOwner() instanceof Connection)) {
            int firstSegmentOrientation;
            PrecisionRectangle source = new PrecisionRectangle(FigureUtilities.getAnchorableFigureBounds(conn.getSourceAnchor().getOwner()));
            conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)source);
            conn.translateToRelative((Translatable)source);
            if (source.contains(line.getPoint(1))) {
                return false;
            }
            int n = firstSegmentOrientation = line.getFirstPoint().x == line.getPoint((int)1).x ? 128 : 64;
            if (this.getOutisePointOffRectanglePosition(line.getPoint(1), (Rectangle)source) != this.getAnchorLocationBasedOnSegmentOrientation(line.getFirstPoint(), (Rectangle)source, firstSegmentOrientation)) {
                return false;
            }
        }
        if (!(conn.getTargetAnchor().getOwner() instanceof Connection)) {
            int lastSegmentOrientation;
            PrecisionRectangle target = new PrecisionRectangle(FigureUtilities.getAnchorableFigureBounds(conn.getTargetAnchor().getOwner()));
            conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)target);
            conn.translateToRelative((Translatable)target);
            if (target.contains(line.getPoint(line.size() - 2))) {
                return false;
            }
            int n = lastSegmentOrientation = line.getLastPoint().x == line.getPoint((int)(line.size() - 2)).x ? 128 : 64;
            if (this.getOutisePointOffRectanglePosition(line.getPoint(line.size() - 2), (Rectangle)target) != this.getAnchorLocationBasedOnSegmentOrientation(line.getLastPoint(), (Rectangle)target, lastSegmentOrientation)) {
                return false;
            }
        }
        return true;
    }

    private void removePointsInViews(Connection conn, PointList newLine, Point start, Point end) {
        int i;
        PrecisionRectangle target;
        if (conn.getSourceAnchor().getOwner() == conn.getTargetAnchor().getOwner()) {
            return;
        }
        PrecisionRectangle source = conn.getSourceAnchor().getOwner() != null ? new PrecisionRectangle(FigureUtilities.getAnchorableFigureBounds(conn.getSourceAnchor().getOwner())) : null;
        PrecisionRectangle precisionRectangle = target = conn.getTargetAnchor().getOwner() != null ? new PrecisionRectangle(FigureUtilities.getAnchorableFigureBounds(conn.getTargetAnchor().getOwner())) : null;
        if (source != null) {
            conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)source);
            conn.translateToRelative((Translatable)source);
        }
        if (target != null) {
            conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)target);
            conn.translateToRelative((Translatable)target);
        }
        Point lastRemovedFromSource = null;
        Point lastRemovedFromTarget = null;
        if (!(conn.getSourceAnchor().getOwner() instanceof Connection) && newLine.size() != 0 && source.contains((Point)new PrecisionPoint(newLine.getFirstPoint()))) {
            lastRemovedFromSource = newLine.removePoint(0);
            i = 0;
            while (i < newLine.size() && source.contains((Point)new PrecisionPoint(newLine.getPoint(i)))) {
                lastRemovedFromSource = newLine.removePoint(i--);
                ++i;
            }
        }
        if (!(conn.getTargetAnchor().getOwner() instanceof Connection) && newLine.size() != 0 && target.contains((Point)new PrecisionPoint(newLine.getLastPoint()))) {
            lastRemovedFromTarget = newLine.removePoint(newLine.size() - 1);
            i = newLine.size();
            while (i > 0 && target.contains((Point)new PrecisionPoint(newLine.getPoint(i - 1)))) {
                lastRemovedFromTarget = newLine.removePoint(i - 1);
                --i;
            }
        }
        if (newLine.size() == 0) {
            Dimension tolerance = new Dimension(1, 0);
            if (!RouterHelper.getInstance().isFeedback(conn)) {
                tolerance = (Dimension)MapModeUtil.getMapMode((IFigure)conn).DPtoLP((Translatable)tolerance);
            }
            int toleranceValue = tolerance.width;
            if (lastRemovedFromSource == null) {
                lastRemovedFromSource = start;
            }
            if (lastRemovedFromTarget == null) {
                lastRemovedFromTarget = end;
            }
            if (Math.abs(lastRemovedFromSource.x - lastRemovedFromTarget.x) < toleranceValue) {
                if (source.preciseY() < target.preciseY()) {
                    newLine.addPoint(lastRemovedFromSource.x, (source.getBottom().y + target.getTop().y) / 2);
                } else {
                    newLine.addPoint(lastRemovedFromSource.x, (source.getTop().y + target.getBottom().y) / 2);
                }
            } else if (Math.abs(lastRemovedFromSource.y - lastRemovedFromTarget.y) < toleranceValue) {
                if (source.preciseX() < target.preciseX()) {
                    newLine.addPoint((source.getRight().x + target.getLeft().x) / 2, lastRemovedFromSource.y);
                } else {
                    newLine.addPoint((source.getLeft().x + target.getRight().x) / 2, lastRemovedFromSource.y);
                }
            } else if (conn.getSourceAnchor() instanceof BaseSlidableAnchor && "".equals(((BaseSlidableAnchor)conn.getSourceAnchor()).getTerminal()) && conn.getTargetAnchor() instanceof BaseSlidableAnchor && "".equals(((BaseSlidableAnchor)conn.getTargetAnchor()).getTerminal())) {
                if (lastRemovedFromSource != null && lastRemovedFromTarget != null) {
                    newLine.addPoint((lastRemovedFromSource.x + lastRemovedFromTarget.x) / 2, (lastRemovedFromSource.y + lastRemovedFromTarget.y) / 2);
                } else {
                    double startX = Math.max(source.preciseX(), target.preciseX());
                    double endX = Math.min(source.preciseX() + source.preciseWidth(), target.preciseX() + target.preciseWidth());
                    double startY = Math.max(source.preciseY(), target.preciseY());
                    double endY = Math.min(source.preciseY() + source.preciseHeight(), target.preciseY() + target.preciseHeight());
                    if (startX < endX) {
                        if (source.preciseY() < target.preciseY()) {
                            newLine.addPoint((int)Math.round((startX + endX) / 2.0), (source.getBottom().y + target.getTop().y) / 2);
                        } else {
                            newLine.addPoint((int)Math.round((startX + endX) / 2.0), (source.getTop().y + target.getBottom().y) / 2);
                        }
                    } else if (startY < endY) {
                        if (source.preciseX() < target.preciseX()) {
                            newLine.addPoint((source.getRight().x + target.getLeft().x) / 2, (int)Math.round((startY + endY) / 2.0));
                        } else {
                            newLine.addPoint((source.getLeft().x + target.getRight().x) / 2, (int)Math.round((startY + endY) / 2.0));
                        }
                    }
                }
            }
        }
    }

    private int getAnchorOffRectangleDirection(Point anchorPoint, Rectangle rect) {
        int position = 1;
        int criteriaValue = Math.abs(anchorPoint.y - rect.y);
        int tempCriteria = Math.abs(anchorPoint.y - rect.y - rect.height);
        if (tempCriteria < criteriaValue) {
            criteriaValue = tempCriteria;
            position = 4;
        }
        if ((tempCriteria = Math.abs(anchorPoint.x - rect.x)) < criteriaValue) {
            criteriaValue = tempCriteria;
            position = 8;
        }
        if ((tempCriteria = Math.abs(anchorPoint.x - rect.x - rect.width)) < criteriaValue) {
            criteriaValue = tempCriteria;
            position = 16;
        }
        return position;
    }

    private Dimension getTranslationValue(int position, int xFactorValue, int yFactorValue) {
        Dimension translationDimension = new Dimension();
        if (position == 16) {
            translationDimension.width = xFactorValue;
        } else if (position == 4) {
            translationDimension.height = yFactorValue;
        } else if (position == 8) {
            translationDimension.width = -xFactorValue;
        } else if (position == 1) {
            translationDimension.height = -yFactorValue;
        }
        return translationDimension;
    }

    private int getOffShapeDirection(int anchorRelativeLocation) {
        if (anchorRelativeLocation == 16 || anchorRelativeLocation == 8) {
            return 64;
        }
        if (anchorRelativeLocation == 1 || anchorRelativeLocation == 4) {
            return 128;
        }
        return 0;
    }

    @Override
    protected void resetEndPointsToEdge(Connection conn, PointList line) {
        if (this.isReorienting(conn)) {
            super.resetEndPointsToEdge(conn, line);
            return;
        }
        PrecisionRectangle source = this.sourceBoundsRelativeToConnection(conn);
        PrecisionRectangle target = this.targetBoundsRelativeToConnection(conn);
        int offSourceDirection = 0;
        int offTargetDirection = 0;
        int sourceAnchorRelativeLocation = 0;
        int targetAnchorRelativeLocation = 0;
        if (line.size() == 0) {
            line.addPoint(new Point());
            line.addPoint(new Point());
            super.resetEndPointsToEdge(conn, line);
            sourceAnchorRelativeLocation = this.getAnchorOffRectangleDirection(line.getFirstPoint(), (Rectangle)source);
            targetAnchorRelativeLocation = this.getAnchorOffRectangleDirection(line.getLastPoint(), (Rectangle)target);
            Point offStart = line.getFirstPoint();
            Point offEnd = line.getLastPoint();
            Dimension offsetDim = offStart.getDifference(offEnd).scale(0.5);
            offStart.translate(this.getTranslationValue(sourceAnchorRelativeLocation, Math.abs(offsetDim.width), Math.abs(offsetDim.height)));
            offEnd.translate(this.getTranslationValue(targetAnchorRelativeLocation, Math.abs(offsetDim.width), Math.abs(offsetDim.height)));
            line.insertPoint(new Point((int)Math.round(offStart.preciseX()), (int)Math.round(offStart.preciseY())), 1);
            line.insertPoint(new Point((int)Math.round(offEnd.preciseX()), (int)Math.round(offEnd.preciseY())), 2);
            offSourceDirection = this.getOffShapeDirection(sourceAnchorRelativeLocation);
            offTargetDirection = this.getOffShapeDirection(targetAnchorRelativeLocation);
        } else {
            PrecisionPoint anchorLocation;
            PrecisionPoint reference;
            Point start = line.getFirstPoint();
            Point end = line.getLastPoint();
            if (conn.getSourceAnchor() instanceof OrthogonalConnectionAnchor) {
                line.insertPoint(OrthogonalRouterUtilities.getOrthogonalLineSegToAnchorLoc(conn, conn.getSourceAnchor(), start).getOrigin(), 0);
            } else {
                reference = new PrecisionPoint(start);
                conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)reference);
                anchorLocation = new PrecisionPoint(conn.getSourceAnchor().getLocation((Point)reference));
                conn.translateToRelative((Translatable)anchorLocation);
                line.insertPoint((Point)anchorLocation, 0);
            }
            if (conn.getTargetAnchor() instanceof OrthogonalConnectionAnchor) {
                line.addPoint(OrthogonalRouterUtilities.getOrthogonalLineSegToAnchorLoc(conn, conn.getTargetAnchor(), end).getOrigin());
            } else {
                reference = new PrecisionPoint(end);
                conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)reference);
                anchorLocation = new PrecisionPoint(conn.getTargetAnchor().getLocation((Point)reference));
                conn.translateToRelative((Translatable)anchorLocation);
                line.addPoint((Point)anchorLocation);
            }
            sourceAnchorRelativeLocation = this.getAnchorOffRectangleDirection(line.getFirstPoint(), (Rectangle)source);
            offSourceDirection = this.getOffShapeDirection(sourceAnchorRelativeLocation);
            targetAnchorRelativeLocation = this.getAnchorOffRectangleDirection(line.getLastPoint(), (Rectangle)target);
            offTargetDirection = this.getOffShapeDirection(targetAnchorRelativeLocation);
        }
        OrthogonalRouterUtilities.transformToOrthogonalPointList(line, offSourceDirection, offTargetDirection);
        this.removeRedundantPoints(line);
    }

    private void normalizeToStraightLineTolerance(PointList line, int tolerance) {
        int i = 0;
        while (i < line.size() - 1) {
            Point pt1 = line.getPoint(i);
            Point pt2 = line.getPoint(i + 1);
            if (Math.abs(pt1.x - pt2.x) < tolerance) {
                line.setPoint(new Point(pt1.x, pt2.y), i + 1);
            } else if (Math.abs(pt1.y - pt2.y) < tolerance) {
                line.setPoint(new Point(pt2.x, pt1.y), i + 1);
            }
            ++i;
        }
    }

    private PrecisionRectangle sourceBoundsRelativeToConnection(Connection conn) {
        PrecisionRectangle source = new PrecisionRectangle(conn.getSourceAnchor().getOwner().getBounds());
        conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)source);
        conn.translateToRelative((Translatable)source);
        return source;
    }

    private PrecisionRectangle targetBoundsRelativeToConnection(Connection conn) {
        PrecisionRectangle target = new PrecisionRectangle(conn.getTargetAnchor().getOwner().getBounds());
        conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)target);
        conn.translateToRelative((Translatable)target);
        return target;
    }

    private int getOutisePointOffRectanglePosition(Point p, Rectangle r) {
        int position = 0;
        if (r.x > p.x) {
            position |= 8;
        } else if (r.x + r.width < p.x) {
            position |= 0x10;
        }
        if (r.y > p.y) {
            position |= 1;
        } else if (r.y + r.height < p.y) {
            position |= 4;
        }
        return position;
    }

    private int getAnchorLocationBasedOnSegmentOrientation(Point anchorPoint, Rectangle rectangle, int segmentOrientation) {
        if (segmentOrientation == 128) {
            if (Math.abs(anchorPoint.y - rectangle.y) < Math.abs(anchorPoint.y - rectangle.y - rectangle.height)) {
                return 1;
            }
            return 4;
        }
        if (segmentOrientation == 64) {
            if (Math.abs(anchorPoint.x - rectangle.x) < Math.abs(anchorPoint.x - rectangle.x - rectangle.width)) {
                return 8;
            }
            return 16;
        }
        return 0;
    }

    private boolean removeRedundantPoints(PointList line) {
        int initialNumberOfPoints = line.size();
        if (line.size() > 2) {
            PointList newLine = new PointList(line.size());
            newLine.addPoint(line.removePoint(0));
            while (line.size() >= 2) {
                Point p0 = newLine.getLastPoint();
                Point p1 = line.getPoint(0);
                Point p2 = line.getPoint(1);
                if (p0.x == p1.x && p0.x == p2.x) {
                    line.removePoint(0);
                    continue;
                }
                if (p0.y == p1.y && p0.y == p2.y) {
                    line.removePoint(0);
                    continue;
                }
                newLine.addPoint(line.removePoint(0));
            }
            while (line.size() > 0) {
                newLine.addPoint(line.removePoint(0));
            }
            line.removeAllPoints();
            line.addAll(newLine);
        }
        return line.size() != initialNumberOfPoints;
    }
}

