/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.formatdata.tools.internal.util;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.formatdata.AbstractFormatData;
import org.eclipse.sirius.diagram.formatdata.EdgeFormatData;
import org.eclipse.sirius.diagram.formatdata.NodeFormatData;
import org.eclipse.sirius.diagram.formatdata.Point;
import org.eclipse.sirius.diagram.formatdata.tools.Messages;
import org.eclipse.sirius.diagram.formatdata.tools.api.util.FormatHelper;
import org.eclipse.sirius.diagram.formatdata.tools.api.util.configuration.Configuration;
import org.eclipse.sirius.diagram.formatdata.tools.api.util.configuration.EdgeConfiguration;
import org.eclipse.sirius.diagram.formatdata.tools.api.util.configuration.NodeConfiguration;

public class FormatHelperImpl
implements FormatHelper {
    @Override
    public boolean haveSameLayout(NodeFormatData nodeFormat1, NodeFormatData nodeFormat2, Configuration configuration) {
        return this.doHaveSameLayout(nodeFormat1, nodeFormat2, configuration) == null;
    }

    private <T extends AbstractFormatData> FormatHelper.FormatDifference<T> doAbstractFormatDataHaveSameLayout(T abstractFormat1, T abstractFormat2, Configuration configuration) {
        FormatDifferenceImpl<T> result = null;
        boolean haveSameLayout = false;
        if (abstractFormat1 == abstractFormat2) {
            haveSameLayout = true;
        } else if (abstractFormat1 != null && abstractFormat2 != null) {
            haveSameLayout = abstractFormat1.getId() != null;
            haveSameLayout = haveSameLayout && abstractFormat1.getId().equals(abstractFormat2.getId());
            boolean bl = haveSameLayout = haveSameLayout && this.haveSameLayout(abstractFormat1.getLabel(), abstractFormat2.getLabel(), configuration);
        }
        if (!haveSameLayout && result == null) {
            result = new FormatDifferenceImpl<T>(abstractFormat1, abstractFormat2, configuration);
        }
        return result;
    }

    private FormatHelper.FormatDifference<? extends AbstractFormatData> doHaveSameLayout(NodeFormatData nodeFormat1, NodeFormatData nodeFormat2, Configuration configuration) {
        FormatHelper.FormatDifference<AbstractFormatData> result = null;
        boolean haveSameLayout = false;
        FormatHelper.FormatDifference<NodeFormatData> abstractDataHaveSameLayout = this.doAbstractFormatDataHaveSameLayout(nodeFormat1, nodeFormat2, configuration);
        boolean bl = haveSameLayout = abstractDataHaveSameLayout == null;
        if (haveSameLayout && nodeFormat1 != null && nodeFormat2 != null) {
            NodeConfiguration nodeConfiguration = configuration.getNodeConfiguration();
            haveSameLayout = haveSameLayout && this.isAroundPoint(nodeFormat1.getLocation(), nodeFormat2.getLocation(), nodeConfiguration.getDistanceAroundPoint());
            haveSameLayout = haveSameLayout && nodeFormat1.getWidth() == nodeFormat2.getWidth();
            boolean bl2 = haveSameLayout = haveSameLayout && nodeFormat1.getHeight() == nodeFormat2.getHeight();
            if (haveSameLayout && configuration.isRecursive()) {
                haveSameLayout = nodeFormat1.getChildren().size() == nodeFormat2.getChildren().size();
                boolean bl3 = haveSameLayout = haveSameLayout && nodeFormat1.getOutgoingEdges().size() == nodeFormat2.getOutgoingEdges().size();
                if (haveSameLayout) {
                    int i = 0;
                    while (i < nodeFormat1.getChildren().size() && haveSameLayout) {
                        result = this.doHaveSameLayout((NodeFormatData)nodeFormat1.getChildren().get(i), (NodeFormatData)nodeFormat2.getChildren().get(i), configuration);
                        haveSameLayout = result == null;
                        ++i;
                    }
                    i = 0;
                    while (i < nodeFormat1.getOutgoingEdges().size() && haveSameLayout) {
                        result = this.doHaveSameLayout((EdgeFormatData)nodeFormat1.getOutgoingEdges().get(i), (EdgeFormatData)nodeFormat2.getOutgoingEdges().get(i), configuration);
                        haveSameLayout = result == null;
                        ++i;
                    }
                }
            }
            if (!haveSameLayout && result == null) {
                result = new FormatDifferenceImpl<NodeFormatData>(nodeFormat1, nodeFormat2, configuration);
            }
        } else {
            result = abstractDataHaveSameLayout;
        }
        return result;
    }

    private boolean isAroundPoint(Point expectedLocation, Point realLocation, double maxDistance) {
        long dy;
        long dx = realLocation.getX() - expectedLocation.getX();
        long distance2 = dx * dx + (dy = (long)(realLocation.getY() - expectedLocation.getY())) * dy;
        return (double)distance2 <= maxDistance * maxDistance;
    }

    @Override
    public FormatHelper.FormatDifference<?> computeFirstFormatDifference(Collection<? extends EObject> col1, Collection<? extends EObject> col2, Configuration configuration) {
        FormatHelper.FormatDifference<Object> result = null;
        boolean haveSameLayout = false;
        if (col1 == col2) {
            haveSameLayout = true;
        } else {
            boolean bl = haveSameLayout = col1 != null && col2 != null && col1.size() == col2.size();
            if (haveSameLayout) {
                Iterator<? extends EObject> it1 = col1.iterator();
                Iterator<? extends EObject> it2 = col2.iterator();
                while (haveSameLayout && it1.hasNext() && it2.hasNext()) {
                    EObject formatData1 = it1.next();
                    EObject formatData2 = it2.next();
                    if (formatData1 instanceof NodeFormatData && formatData2 instanceof NodeFormatData) {
                        result = this.doHaveSameLayout((NodeFormatData)formatData1, (NodeFormatData)formatData2, configuration);
                    } else if (formatData1 instanceof EdgeFormatData && formatData2 instanceof EdgeFormatData) {
                        result = this.doHaveSameLayout((EdgeFormatData)formatData1, (EdgeFormatData)formatData2, configuration);
                    }
                    boolean bl2 = haveSameLayout = result == null;
                }
            }
        }
        if (!haveSameLayout && result == null) {
            result = new FormatDifferenceImpl<Collection<? extends EObject>>(col1, col2, configuration);
        }
        return result;
    }

    @Override
    public boolean haveSameLayout(Collection<? extends EObject> col1, Collection<? extends EObject> col2, Configuration configuration) {
        return this.computeFirstFormatDifference(col1, col2, configuration) == null;
    }

    @Override
    public boolean haveSameLayout(EdgeFormatData edgeFormat1, EdgeFormatData edgeFormat2, Configuration configuration) {
        return this.doHaveSameLayout(edgeFormat1, edgeFormat2, configuration) == null;
    }

    private FormatHelper.FormatDifference<EdgeFormatData> doHaveSameLayout(EdgeFormatData edgeFormat1, EdgeFormatData edgeFormat2, Configuration configuration) {
        FormatHelper.FormatDifference<EdgeFormatData> result = null;
        boolean haveSameLayout = false;
        FormatHelper.FormatDifference<EdgeFormatData> abstractDataHaveSameLayout = this.doAbstractFormatDataHaveSameLayout(edgeFormat1, edgeFormat2, configuration);
        boolean bl = haveSameLayout = abstractDataHaveSameLayout == null;
        if (haveSameLayout && edgeFormat1 != null && edgeFormat2 != null) {
            EdgeConfiguration edgeConfiguration = configuration.getEdgeConfiguration();
            haveSameLayout = haveSameLayout && StringUtil.equals((CharSequence)edgeFormat1.getSourceTerminal(), (CharSequence)edgeFormat2.getSourceTerminal());
            haveSameLayout = haveSameLayout && StringUtil.equals((CharSequence)edgeFormat1.getTargetTerminal(), (CharSequence)edgeFormat2.getTargetTerminal());
            boolean bl2 = haveSameLayout = haveSameLayout && edgeFormat1.getRouting() == edgeFormat2.getRouting();
            if (edgeFormat1.getSourceRefPoint() != null && edgeFormat2.getSourceRefPoint() != null) {
                haveSameLayout = haveSameLayout && this.isAroundPoint(edgeFormat1.getSourceRefPoint(), edgeFormat2.getSourceRefPoint(), edgeConfiguration.getDistanceAroundPointsOfEdgeBendpointsList());
            }
            boolean bl3 = haveSameLayout = haveSameLayout && edgeFormat1.getPointList().size() == edgeFormat2.getPointList().size();
            if (haveSameLayout) {
                int i = 0;
                while (i < edgeFormat1.getPointList().size() && haveSameLayout) {
                    haveSameLayout = this.isAroundPoint((Point)edgeFormat1.getPointList().get(i), (Point)edgeFormat2.getPointList().get(i), edgeConfiguration.getDistanceAroundPointsOfEdgeBendpointsList());
                    ++i;
                }
            }
            if (!haveSameLayout) {
                result = new FormatDifferenceImpl<EdgeFormatData>(edgeFormat1, edgeFormat2, configuration);
            }
        } else {
            result = abstractDataHaveSameLayout;
        }
        return result;
    }

    private static String toString(EObject eobject) {
        return FormatHelperImpl.toString("\n", eobject);
    }

    private static String toString(String prefix, EObject eobject) {
        StringBuilder sb = new StringBuilder();
        EClass eClass = eobject.eClass();
        int size = eClass.getFeatureCount();
        int i = 0;
        while (i < size) {
            EStructuralFeature feature = eClass.getEStructuralFeature(i);
            if (!feature.isDerived()) {
                sb.append(prefix);
                sb.append(feature.getName());
                sb.append(" : ");
                Object obj = eobject.eGet(feature);
                if (obj == null) {
                    sb.append("null");
                } else if (obj instanceof EObject) {
                    sb.append(FormatHelperImpl.toString("\n     ", (EObject)obj));
                } else if (obj instanceof List) {
                    List list = (List)obj;
                    if (!list.isEmpty()) {
                        sb.append('\n');
                        sb.append("     ");
                    }
                    for (Object object : list) {
                        sb.append('\n');
                        sb.append("     ");
                        if (object instanceof EObject) {
                            sb.append(FormatHelperImpl.toString((EObject)object));
                            continue;
                        }
                        sb.append(object.toString());
                    }
                } else {
                    sb.append(obj.toString());
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static final class FormatDifferenceImpl<T>
    implements FormatHelper.FormatDifference<T> {
        private final T leftElement;
        private final T rightElement;
        private final Configuration configuration;

        private FormatDifferenceImpl(T leftElement, T rightElement, Configuration configuration) {
            this.leftElement = leftElement;
            this.rightElement = rightElement;
            this.configuration = configuration;
        }

        @Override
        public String getMessage() {
            return MessageFormat.format(Messages.FormatHelperImpl_formatDifferenceMessage, this.configuration, this.elementToString(this.leftElement), this.elementToString(this.rightElement));
        }

        private String elementToString(T element) {
            String elementToString = this.leftElement instanceof EObject ? FormatHelperImpl.toString((EObject)element) : element.toString();
            return elementToString;
        }

        @Override
        public T getLeftElement() {
            return this.leftElement;
        }

        @Override
        public T getRightElement() {
            return this.rightElement;
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

