/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.impl;

import java.util.Arrays;
import org.eclipse.emf.cdo.expressions.Expression;
import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.AndFilter;
import org.eclipse.emf.cdo.security.ClassFilter;
import org.eclipse.emf.cdo.security.ClassPermission;
import org.eclipse.emf.cdo.security.Directory;
import org.eclipse.emf.cdo.security.ExpressionFilter;
import org.eclipse.emf.cdo.security.FilterPermission;
import org.eclipse.emf.cdo.security.Group;
import org.eclipse.emf.cdo.security.LinkedFilter;
import org.eclipse.emf.cdo.security.NotFilter;
import org.eclipse.emf.cdo.security.OrFilter;
import org.eclipse.emf.cdo.security.PackageFilter;
import org.eclipse.emf.cdo.security.PackagePermission;
import org.eclipse.emf.cdo.security.PatternStyle;
import org.eclipse.emf.cdo.security.PermissionFilter;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.ResourceFilter;
import org.eclipse.emf.cdo.security.ResourcePermission;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.security.UserPassword;
import org.eclipse.emf.cdo.security.impl.AndFilterImpl;
import org.eclipse.emf.cdo.security.impl.ClassFilterImpl;
import org.eclipse.emf.cdo.security.impl.ClassPermissionImpl;
import org.eclipse.emf.cdo.security.impl.DirectoryImpl;
import org.eclipse.emf.cdo.security.impl.ExpressionFilterImpl;
import org.eclipse.emf.cdo.security.impl.FilterPermissionImpl;
import org.eclipse.emf.cdo.security.impl.GroupImpl;
import org.eclipse.emf.cdo.security.impl.LinkedFilterImpl;
import org.eclipse.emf.cdo.security.impl.NotFilterImpl;
import org.eclipse.emf.cdo.security.impl.OrFilterImpl;
import org.eclipse.emf.cdo.security.impl.PackageFilterImpl;
import org.eclipse.emf.cdo.security.impl.PackagePermissionImpl;
import org.eclipse.emf.cdo.security.impl.RealmImpl;
import org.eclipse.emf.cdo.security.impl.ResourceFilterImpl;
import org.eclipse.emf.cdo.security.impl.ResourcePermissionImpl;
import org.eclipse.emf.cdo.security.impl.RoleImpl;
import org.eclipse.emf.cdo.security.impl.UserImpl;
import org.eclipse.emf.cdo.security.impl.UserPasswordImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.net4j.util.StringUtil;

public class SecurityFactoryImpl
extends EFactoryImpl
implements SecurityFactory {
    public static final Access DEFAULT_PERMISSION = Access.WRITE;

    public static SecurityFactory init() {
        try {
            SecurityFactory theSecurityFactory = (SecurityFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/CDO/security/4.1.0");
            if (theSecurityFactory != null) {
                return theSecurityFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new SecurityFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 2: {
                return this.createRealm();
            }
            case 3: {
                return this.createDirectory();
            }
            case 4: {
                return this.createRole();
            }
            case 6: {
                return this.createGroup();
            }
            case 7: {
                return this.createUser();
            }
            case 8: {
                return this.createUserPassword();
            }
            case 10: {
                return this.createClassPermission();
            }
            case 11: {
                return this.createPackagePermission();
            }
            case 12: {
                return this.createResourcePermission();
            }
            case 14: {
                return this.createFilterPermission();
            }
            case 16: {
                return this.createLinkedFilter();
            }
            case 17: {
                return this.createPackageFilter();
            }
            case 18: {
                return this.createClassFilter();
            }
            case 19: {
                return this.createResourceFilter();
            }
            case 21: {
                return this.createExpressionFilter();
            }
            case 23: {
                return this.createNotFilter();
            }
            case 24: {
                return this.createAndFilter();
            }
            case 25: {
                return this.createOrFilter();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 26: {
                return this.createPatternStyleFromString(eDataType, initialValue);
            }
            case 27: {
                return this.createAccessFromString(eDataType, initialValue);
            }
            case 28: {
                return this.createAccessObjectFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 26: {
                return this.convertPatternStyleToString(eDataType, instanceValue);
            }
            case 27: {
                return this.convertAccessToString(eDataType, instanceValue);
            }
            case 28: {
                return this.convertAccessObjectToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Realm createRealm() {
        RealmImpl realm = new RealmImpl();
        return realm;
    }

    @Override
    public Realm createRealm(String name) {
        Realm realm = this.createRealm();
        realm.setName(name);
        return realm;
    }

    @Override
    public Realm createRealm(String name, Access defaultAccess) {
        Realm realm = this.createRealm(name);
        realm.setDefaultAccess(defaultAccess);
        return realm;
    }

    @Override
    public Directory createDirectory(String name) {
        Directory directory = this.createDirectory();
        directory.setName(name);
        return directory;
    }

    @Override
    public Role createRole(String id) {
        Role role = this.createRole();
        role.setId(id);
        return role;
    }

    @Override
    public Group createGroup(String id) {
        Group group = this.createGroup();
        group.setId(id);
        return group;
    }

    @Override
    public User createUser(String id) {
        User user = this.createUser();
        user.setId(id);
        return user;
    }

    @Override
    public User createUser(String id, String password) {
        UserPassword userPassword = this.createUserPassword();
        userPassword.setEncrypted(password);
        User user = this.createUser(id);
        user.setPassword(userPassword);
        return user;
    }

    @Override
    @Deprecated
    public ClassPermission createClassPermission(EClass eClass, Access access) {
        ClassPermission permission = this.createClassPermission();
        permission.setApplicableClass(eClass);
        permission.setAccess(access);
        return permission;
    }

    @Override
    @Deprecated
    public PackagePermission createPackagePermission(EPackage ePackage, Access access) {
        PackagePermission permission = this.createPackagePermission();
        permission.setApplicablePackage(ePackage);
        permission.setAccess(access);
        return permission;
    }

    @Override
    @Deprecated
    public ResourcePermission createResourcePermission(String pattern, Access access) {
        ResourcePermission permission = this.createResourcePermission();
        permission.setPattern(pattern);
        permission.setAccess(access);
        return permission;
    }

    @Override
    public Directory createDirectory() {
        DirectoryImpl directory = new DirectoryImpl();
        return directory;
    }

    @Override
    public Role createRole() {
        RoleImpl role = new RoleImpl();
        return role;
    }

    @Override
    public Group createGroup() {
        GroupImpl group = new GroupImpl();
        return group;
    }

    @Override
    public User createUser() {
        UserImpl user = new UserImpl();
        return user;
    }

    @Override
    public UserPassword createUserPassword() {
        UserPasswordImpl userPassword = new UserPasswordImpl();
        return userPassword;
    }

    @Override
    @Deprecated
    public ClassPermission createClassPermission() {
        ClassPermissionImpl classPermission = new ClassPermissionImpl();
        return classPermission;
    }

    @Override
    @Deprecated
    public PackagePermission createPackagePermission() {
        PackagePermissionImpl packagePermission = new PackagePermissionImpl();
        return packagePermission;
    }

    @Override
    @Deprecated
    public ResourcePermission createResourcePermission() {
        ResourcePermissionImpl resourcePermission = new ResourcePermissionImpl();
        return resourcePermission;
    }

    @Override
    public FilterPermission createFilterPermission() {
        FilterPermissionImpl filterPermission = new FilterPermissionImpl();
        return filterPermission;
    }

    @Override
    public LinkedFilter createLinkedFilter() {
        LinkedFilterImpl linkedFilter = new LinkedFilterImpl();
        return linkedFilter;
    }

    @Override
    public FilterPermission createFilterPermission(Access access, PermissionFilter ... filters) {
        FilterPermission permission = this.createFilterPermission();
        permission.setAccess(access);
        permission.getFilters().addAll(Arrays.asList(filters));
        return permission;
    }

    @Override
    public PackageFilter createPackageFilter() {
        PackageFilterImpl packageFilter = new PackageFilterImpl();
        return packageFilter;
    }

    @Override
    public PackageFilter createPackageFilter(EPackage ePackage) {
        PackageFilter filter = this.createPackageFilter();
        filter.setApplicablePackage(ePackage);
        return filter;
    }

    @Override
    public ClassFilter createClassFilter() {
        ClassFilterImpl classFilter = new ClassFilterImpl();
        return classFilter;
    }

    @Override
    public ClassFilter createClassFilter(EClass eClass) {
        ClassFilter filter = this.createClassFilter();
        filter.setApplicableClass(eClass);
        return filter;
    }

    @Override
    public ResourceFilter createResourceFilter() {
        ResourceFilterImpl resourceFilter = new ResourceFilterImpl();
        return resourceFilter;
    }

    @Override
    public ResourceFilter createResourceFilter(String path) {
        ResourceFilter filter = this.createResourceFilter();
        filter.setPath(path);
        return filter;
    }

    @Override
    public ResourceFilter createResourceFilter(String path, PatternStyle patternStyle) {
        ResourceFilter filter = this.createResourceFilter(path);
        filter.setPatternStyle(patternStyle);
        return filter;
    }

    @Override
    public ResourceFilter createResourceFilter(String path, PatternStyle patternStyle, boolean includeParents) {
        ResourceFilter filter = this.createResourceFilter(path, patternStyle);
        filter.setIncludeParents(includeParents);
        return filter;
    }

    @Override
    public ExpressionFilter createExpressionFilter() {
        ExpressionFilterImpl expressionFilter = new ExpressionFilterImpl();
        return expressionFilter;
    }

    @Override
    public ExpressionFilter createExpressionFilter(Expression expression) {
        ExpressionFilter filter = this.createExpressionFilter();
        filter.setExpression(expression);
        return filter;
    }

    @Override
    public NotFilter createNotFilter() {
        NotFilterImpl notFilter = new NotFilterImpl();
        return notFilter;
    }

    @Override
    public NotFilter createNotFilter(PermissionFilter operand) {
        NotFilter filter = this.createNotFilter();
        filter.getOperands().add((Object)operand);
        return filter;
    }

    @Override
    public AndFilter createAndFilter() {
        AndFilterImpl andFilter = new AndFilterImpl();
        return andFilter;
    }

    @Override
    public AndFilter createAndFilter(PermissionFilter ... operands) {
        AndFilter filter = this.createAndFilter();
        filter.getOperands().addAll(Arrays.asList(operands));
        return filter;
    }

    @Override
    public OrFilter createOrFilter() {
        OrFilterImpl orFilter = new OrFilterImpl();
        return orFilter;
    }

    public PatternStyle createPatternStyleFromString(EDataType eDataType, String initialValue) {
        PatternStyle result = PatternStyle.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertPatternStyleToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public OrFilter createOrFilter(PermissionFilter ... operands) {
        OrFilter filter = this.createOrFilter();
        filter.getOperands().addAll(Arrays.asList(operands));
        return filter;
    }

    public Access createAccessFromString(EDataType eDataType, String initialValue) {
        if (!StringUtil.isEmpty((String)initialValue)) {
            return Access.get(initialValue);
        }
        return null;
    }

    public String convertAccessToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Access createAccessObjectFromString(EDataType eDataType, String initialValue) {
        return this.createAccessFromString((EDataType)SecurityPackage.Literals.ACCESS, initialValue);
    }

    public String convertAccessObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertAccessToString((EDataType)SecurityPackage.Literals.ACCESS, instanceValue);
    }

    @Override
    public SecurityPackage getSecurityPackage() {
        return (SecurityPackage)this.getEPackage();
    }

    @Deprecated
    public static SecurityPackage getPackage() {
        return SecurityPackage.eINSTANCE;
    }
}

