/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.helper.task;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.helper.task.ExecuteToolOperationTask;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class TaskHelper {
    private ModelAccessor modelAccessor;
    private UICallBack uiCallback;

    public TaskHelper(ModelAccessor modelAccessor, UICallBack uiCallback) {
        this.modelAccessor = modelAccessor;
        this.uiCallback = uiCallback;
    }

    public ICommandTask buildTaskFromModelOperation(EObject target, ModelOperation op) {
        return new ExecuteToolOperationTask(this.modelAccessor, target, op, this.uiCallback);
    }

    public ICommandTask buildTaskFromModelOperation(DRepresentation representation, EObject target, ModelOperation op) {
        ExecuteToolOperationTask task = new ExecuteToolOperationTask(this.modelAccessor, target, representation, op, this.uiCallback);
        return task;
    }

    public Set<DSemanticDecorator> getDElementToClearFromSemanticElements(EObject context, Set<EObject> semanticElements) {
        Set<DSemanticDecorator> decoratorsToDestroy = new HashSet<DSemanticDecorator>();
        if (context != null) {
            ECrossReferenceAdapter xref = this.getSemanticCrossReferencer(context);
            decoratorsToDestroy = xref != null ? this.getDElementToClearWithXref(context, semanticElements, xref) : this.getDElementToClearWithoutXref(context, semanticElements);
        }
        return decoratorsToDestroy;
    }

    private Set<DSemanticDecorator> getDElementToClearWithXref(EObject context, Set<EObject> semanticElements, ECrossReferenceAdapter xref) {
        HashSet<DSemanticDecorator> decoratorsToDestroy = new HashSet<DSemanticDecorator>();
        if (context instanceof DAnalysis || context instanceof DView || context instanceof DRepresentation) {
            for (EObject semElt : semanticElements) {
                for (EStructuralFeature.Setting setting : xref.getInverseReferences(semElt)) {
                    DRepresentationElement repElt;
                    EObject eObj = setting.getEObject();
                    if (setting.getEStructuralFeature().equals(ViewpointPackage.Literals.DSEMANTIC_DECORATOR__TARGET) && this.isAncestor(context, eObj)) {
                        decoratorsToDestroy.add((DSemanticDecorator)eObj);
                        continue;
                    }
                    if (decoratorsToDestroy.contains(eObj) || !setting.getEStructuralFeature().equals(ViewpointPackage.Literals.DREPRESENTATION_ELEMENT__SEMANTIC_ELEMENTS) || !this.isAncestor(context, eObj) || !semanticElements.containsAll((Collection<?>)(repElt = (DRepresentationElement)eObj).getSemanticElements())) continue;
                    decoratorsToDestroy.add((DSemanticDecorator)repElt);
                }
            }
        }
        return decoratorsToDestroy;
    }

    private boolean isAncestor(EObject context, EObject object) {
        EObject son = object;
        if (context instanceof DAnalysis || context instanceof DView) {
            Option<DRepresentation> representation = new EObjectQuery(object).getRepresentation();
            DRepresentationDescriptor representationDescriptor = new DRepresentationQuery((DRepresentation)representation.get()).getRepresentationDescriptor();
            son = representationDescriptor;
        }
        return EcoreUtil.isAncestor((EObject)context, (EObject)son);
    }

    private ECrossReferenceAdapter getSemanticCrossReferencer(EObject root) {
        Session session = null;
        if (root instanceof DAnalysis) {
            for (Session tempSession : SessionManager.INSTANCE.getSessions()) {
                if (!tempSession.getAllSessionResources().contains(root.eResource())) continue;
                session = tempSession;
            }
        } else {
            session = root instanceof DSemanticDecorator ? SessionManager.INSTANCE.getSession(((DSemanticDecorator)root).getTarget()) : SessionManager.INSTANCE.getSession(root);
        }
        ECrossReferenceAdapter xref = null;
        if (session != null && session.getSemanticCrossReferencer() != null) {
            xref = session.getSemanticCrossReferencer();
        }
        return xref;
    }

    private Set<DSemanticDecorator> getDElementToClearWithoutXref(EObject root, Set<EObject> semanticElements) {
        HashSet<DSemanticDecorator> decoratorsToDestroy = new HashSet<DSemanticDecorator>();
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            DRepresentationElement representationElement;
            DSemanticDecorator decorator;
            EObject eObj = (EObject)it.next();
            boolean toDestroy = false;
            if (eObj instanceof DSemanticDecorator && semanticElements.contains((decorator = (DSemanticDecorator)eObj).getTarget())) {
                toDestroy = decoratorsToDestroy.add(decorator);
            }
            if (toDestroy || !(eObj instanceof DRepresentationElement) || !semanticElements.containsAll((Collection<?>)(representationElement = (DRepresentationElement)eObj).getSemanticElements())) continue;
            decoratorsToDestroy.add((DSemanticDecorator)representationElement);
        }
        return decoratorsToDestroy;
    }

    public boolean checkPrecondition(EObject container, AbstractToolDescription toolDescription) {
        HashMap<String, EObject> variables = new HashMap<String, EObject>();
        variables.put("container", container);
        return TaskHelper.checkPrecondition(container, toolDescription, variables, true, false);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean checkPrecondition(EObject context, AbstractToolDescription toolDescription, Map<String, EObject> variablesToSet, boolean catchExceptionSilently, boolean flagCondition) {
        result = false;
        if (toolDescription.getPrecondition() == null || StringUtil.isEmpty((String)toolDescription.getPrecondition())) {
            result = true;
        } else {
            interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(context);
            try {
                for (Map.Entry<String, EObject> variableToSet : variablesToSet.entrySet()) {
                    interpreter.setVariable(variableToSet.getKey(), (Object)variableToSet.getValue());
                }
                if (catchExceptionSilently) {
                    try {
                        result = interpreter.evaluateBoolean(context, toolDescription.getPrecondition());
                    }
                    catch (EvaluationException v0) {
                    }
                }
                result = RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateBoolean(context, (EObject)toolDescription, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition());
            }
            finally {
                ** for (variableNameToUnset : variablesToSet.keySet())
            }
lbl-1000:
            // 1 sources

            {
                interpreter.unSetVariable(variableNameToUnset);
                continue;
            }
        }
lbl22:
        // 2 sources

        return result;
    }
}

