/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.helper.task.label;

import java.text.MessageFormat;
import java.text.ParseException;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.tools.api.Messages;

public class InitInterpreterFromParsedVariableTask2
extends AbstractCommandTask {
    private static final String DEFAULT_MESSAGE_MASK = "{0}";
    private IInterpreter interpreter;
    private String messageMask;
    private Object message;
    private boolean unset;

    public InitInterpreterFromParsedVariableTask2(IInterpreter inter, String messageFormat, Object message) {
        this.interpreter = inter;
        this.messageMask = messageFormat;
        this.message = message;
    }

    public InitInterpreterFromParsedVariableTask2(IInterpreter inter, String messageFormat, Object message, boolean unset) {
        this.interpreter = inter;
        this.messageMask = messageFormat;
        this.message = message;
        this.unset = unset;
    }

    @Override
    public void execute() {
        if (this.message == null || this.message instanceof String && ((String)this.message).length() == 0) {
            if (this.unset) {
                this.unSetVariable(0);
            } else {
                this.setVariable(0, "");
            }
        } else if (DEFAULT_MESSAGE_MASK.equals(this.messageMask) && !(this.message instanceof String)) {
            if (this.unset) {
                this.unSetVariable(0);
            } else {
                this.setVariable(0, this.message);
            }
        } else {
            String strMsg = this.message.toString();
            MessageFormat parser = new MessageFormat(this.messageMask);
            try {
                Object[] values = parser.parse(strMsg);
                int i = 0;
                while (i < values.length) {
                    if (this.unset) {
                        this.unSetVariable(i);
                    } else {
                        this.setVariable(i, values[i]);
                    }
                    ++i;
                }
            }
            catch (ParseException parseException) {}
        }
    }

    private void unSetVariable(Integer i) {
        this.interpreter.unSetVariable(i.toString());
        this.interpreter.unSetVariable("arg" + i.toString());
    }

    private void setVariable(Integer i, Object value) {
        this.interpreter.setVariable(i.toString(), value);
        this.interpreter.setVariable("arg" + i.toString(), value);
    }

    @Override
    public boolean canExecute() {
        boolean canExecute = true;
        if (this.message == null || this.message instanceof String && ((String)this.message).length() == 0) {
            canExecute = true;
        } else if (DEFAULT_MESSAGE_MASK.equals(this.messageMask) && !(this.message instanceof String)) {
            canExecute = true;
        } else {
            String strMsg = this.message.toString();
            MessageFormat parser = new MessageFormat(this.messageMask);
            try {
                parser.parse(strMsg);
            }
            catch (ParseException parseException) {
                canExecute = false;
            }
        }
        return canExecute;
    }

    @Override
    public String getLabel() {
        if (this.unset) {
            return Messages.InitInterpreterFromParsedVariableTask_unsetLabel;
        }
        return Messages.InitInterpreterFromParsedVariableTask_label;
    }
}

