/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.internal.core.model;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.internal.core.model.CommentContainer;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsPackage;

public abstract class ReviewItem
extends CommentContainer
implements IReviewItem {
    protected IUser addedBy;
    protected IUser committedBy;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String ID_EDEFAULT = null;
    protected String id = ID_EDEFAULT;
    protected static final String REFERENCE_EDEFAULT = null;
    protected String reference = REFERENCE_EDEFAULT;

    protected ReviewItem() {
    }

    @Override
    protected EClass eStaticClass() {
        return ReviewsPackage.Literals.REVIEW_ITEM;
    }

    @Override
    public List<IComment> getAllComments() {
        return this.getComments();
    }

    @Override
    public IUser getAddedBy() {
        if (this.addedBy != null && this.addedBy.eIsProxy()) {
            InternalEObject oldAddedBy = (InternalEObject)this.addedBy;
            this.addedBy = (IUser)this.eResolveProxy(oldAddedBy);
            if (this.addedBy != oldAddedBy && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldAddedBy, (Object)this.addedBy));
            }
        }
        return this.addedBy;
    }

    public IUser basicGetAddedBy() {
        return this.addedBy;
    }

    @Override
    public void setAddedBy(IUser newAddedBy) {
        IUser oldAddedBy = this.addedBy;
        this.addedBy = newAddedBy;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldAddedBy, (Object)this.addedBy));
        }
    }

    @Override
    public IUser getCommittedBy() {
        if (this.committedBy != null && this.committedBy.eIsProxy()) {
            InternalEObject oldCommittedBy = (InternalEObject)this.committedBy;
            this.committedBy = (IUser)this.eResolveProxy(oldCommittedBy);
            if (this.committedBy != oldCommittedBy && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldCommittedBy, (Object)this.committedBy));
            }
        }
        return this.committedBy;
    }

    public IUser basicGetCommittedBy() {
        return this.committedBy;
    }

    @Override
    public void setCommittedBy(IUser newCommittedBy) {
        IUser oldCommittedBy = this.committedBy;
        this.committedBy = newCommittedBy;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldCommittedBy, (Object)this.committedBy));
        }
    }

    @Override
    public IReview getReview() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String newId) {
        String oldId = this.id;
        this.id = newId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldId, (Object)this.id));
        }
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String newReference) {
        String oldReference = this.reference;
        this.reference = newReference;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldReference, (Object)this.reference));
        }
    }

    @Override
    public IComment createComment(ILocation initalLocation, String commentText) {
        IComment comment = super.createComment(initalLocation, commentText);
        if (this.getReview() != null && this.getReview().getRepository() != null) {
            comment.setAuthor(this.getReview().getRepository().getAccount());
        }
        return comment;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 4: {
                if (resolve) {
                    return this.getAddedBy();
                }
                return this.basicGetAddedBy();
            }
            case 5: {
                if (resolve) {
                    return this.getCommittedBy();
                }
                return this.basicGetCommittedBy();
            }
            case 6: {
                return this.getReview();
            }
            case 7: {
                return this.getName();
            }
            case 8: {
                return this.getId();
            }
            case 9: {
                return this.getReference();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 4: {
                this.setAddedBy((IUser)newValue);
                return;
            }
            case 5: {
                this.setCommittedBy((IUser)newValue);
                return;
            }
            case 7: {
                this.setName((String)newValue);
                return;
            }
            case 8: {
                this.setId((String)newValue);
                return;
            }
            case 9: {
                this.setReference((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 4: {
                this.setAddedBy(null);
                return;
            }
            case 5: {
                this.setCommittedBy(null);
                return;
            }
            case 7: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 8: {
                this.setId(ID_EDEFAULT);
                return;
            }
            case 9: {
                this.setReference(REFERENCE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 4: {
                return this.addedBy != null;
            }
            case 5: {
                return this.committedBy != null;
            }
            case 6: {
                return this.getReview() != null;
            }
            case 7: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 8: {
                return ID_EDEFAULT == null ? this.id != null : !ID_EDEFAULT.equals(this.id);
            }
            case 9: {
                return REFERENCE_EDEFAULT == null ? this.reference != null : !REFERENCE_EDEFAULT.equals(this.reference);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", id: ");
        result.append(this.id);
        result.append(", reference: ");
        result.append(this.reference);
        result.append(')');
        return result.toString();
    }
}

