/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.internal.ui.dialogs.CreateBranchDialog;
import org.eclipse.emf.cdo.internal.ui.handlers.CreateBranchHandler;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.net4j.util.ui.actions.LongRunningAction;
import org.eclipse.ui.IWorkbenchPage;

public class CreateBranchAction
extends LongRunningAction {
    public static final String ID = "create-branch";
    private static final String TITLE = Messages.getString("CreateBranchAction.0");
    private static final String TOOL_TIP = Messages.getString("CreateBranchAction.1");
    private CDOBranchPoint base;
    private String name;

    public CreateBranchAction(IWorkbenchPage page, CDOBranchPoint base) {
        super(page, TITLE + INTERACTIVE, TOOL_TIP, null);
        this.base = base;
        this.setId(ID);
    }

    public final CDOBranchPoint getBase() {
        return this.base;
    }

    public final String getName() {
        return this.name;
    }

    protected void preRun() throws Exception {
        this.name = CreateBranchHandler.getValidChildName(this.base.getBranch());
        CreateBranchDialog dialog = new CreateBranchDialog(this.getShell(), this.base, this.name);
        if (dialog.open() == 0) {
            this.base = dialog.getBranchPoint();
            this.name = dialog.getName();
            return;
        }
        this.base = null;
        this.name = null;
        this.cancel();
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        CDOBranch branch = this.base.getBranch();
        branch.createBranch(this.name, this.base.getTimeStamp());
    }
}

