/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.DotFileUtils;
import org.eclipse.gef.dot.internal.language.DotAstHelper;
import org.eclipse.gef.dot.internal.language.DotStandaloneSetup;
import org.eclipse.gef.dot.internal.language.dot.AttrList;
import org.eclipse.gef.dot.internal.language.dot.AttrStmt;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.AttributeType;
import org.eclipse.gef.dot.internal.language.dot.DotAst;
import org.eclipse.gef.dot.internal.language.dot.DotFactory;
import org.eclipse.gef.dot.internal.language.dot.DotGraph;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhs;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhsNode;
import org.eclipse.gef.dot.internal.language.dot.EdgeStmtNode;
import org.eclipse.gef.dot.internal.language.dot.NodeId;
import org.eclipse.gef.dot.internal.language.dot.NodeStmt;
import org.eclipse.gef.dot.internal.language.dot.Stmt;
import org.eclipse.gef.dot.internal.language.dot.Subgraph;
import org.eclipse.gef.dot.internal.language.parser.antlr.DotParser;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.Node;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class DotImport {
    @Inject
    private static IParser dotParser;
    private final HashMap<ArrayList<?>, Map<String, ID>> _createCache_globalGraphAttributes = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Map<String, ID>> _createCache_globalNodeAttributes = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Map<String, ID>> _createCache_globalEdgeAttributes = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Node> _createCache_createSubgraph = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Node> _createCache_createNode = CollectionLiterals.newHashMap();

    private static IParser getDotParser() {
        if (dotParser == null) {
            dotParser = (IParser)new DotStandaloneSetup().createInjectorAndDoEMFRegistration().getInstance(DotParser.class);
        }
        return dotParser;
    }

    public List<Graph> importDot(File dotFile) {
        return this.importDot(DotFileUtils.read(dotFile));
    }

    public List<Graph> importDot(String dotString) {
        StringReader _stringReader;
        List<Graph> _xblockexpression = null;
        IParser _dotParser = DotImport.getDotParser();
        IParseResult parseResult = _dotParser.parse((Reader)(_stringReader = new StringReader(dotString)));
        boolean _hasSyntaxErrors = parseResult.hasSyntaxErrors();
        if (_hasSyntaxErrors) {
            Functions.Function1 _function = it -> it.getSyntaxErrorMessage().getMessage();
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)parseResult.getSyntaxErrors(), (Functions.Function1)_function), (CharSequence)",");
            String _plus = "Given DOT string is not valid: " + _join;
            throw new IllegalArgumentException(_plus);
        }
        EObject _rootASTElement = parseResult.getRootASTElement();
        _xblockexpression = this.importDot((DotAst)_rootASTElement);
        return _xblockexpression;
    }

    public List<Graph> importDot(DotAst dotAst) {
        Functions.Function1 _function = it -> this.transformDotGraph((DotGraph)it);
        return IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map(dotAst.getGraphs(), (Functions.Function1)_function)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ID> globalGraphAttributes(Graph.Builder context) {
        HashMap _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Graph.Builder[]{context});
        HashMap<ArrayList<?>, Map<String, ID>> hashMap = this._createCache_globalGraphAttributes;
        synchronized (hashMap) {
            HashMap _newHashMap;
            if (this._createCache_globalGraphAttributes.containsKey(_cacheKey)) {
                return this._createCache_globalGraphAttributes.get(_cacheKey);
            }
            _result = _newHashMap = CollectionLiterals.newHashMap();
            this._createCache_globalGraphAttributes.put(_cacheKey, _result);
        }
        this._init_globalGraphAttributes(_result, context);
        return _result;
    }

    private void _init_globalGraphAttributes(HashMap<String, ID> it, Graph.Builder context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ID> globalNodeAttributes(Graph.Builder context) {
        HashMap _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Graph.Builder[]{context});
        HashMap<ArrayList<?>, Map<String, ID>> hashMap = this._createCache_globalNodeAttributes;
        synchronized (hashMap) {
            HashMap _newHashMap;
            if (this._createCache_globalNodeAttributes.containsKey(_cacheKey)) {
                return this._createCache_globalNodeAttributes.get(_cacheKey);
            }
            _result = _newHashMap = CollectionLiterals.newHashMap();
            this._createCache_globalNodeAttributes.put(_cacheKey, _result);
        }
        this._init_globalNodeAttributes(_result, context);
        return _result;
    }

    private void _init_globalNodeAttributes(HashMap<String, ID> it, Graph.Builder context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ID> globalEdgeAttributes(Graph.Builder context) {
        HashMap _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Graph.Builder[]{context});
        HashMap<ArrayList<?>, Map<String, ID>> hashMap = this._createCache_globalEdgeAttributes;
        synchronized (hashMap) {
            HashMap _newHashMap;
            if (this._createCache_globalEdgeAttributes.containsKey(_cacheKey)) {
                return this._createCache_globalEdgeAttributes.get(_cacheKey);
            }
            _result = _newHashMap = CollectionLiterals.newHashMap();
            this._createCache_globalEdgeAttributes.put(_cacheKey, _result);
        }
        this._init_globalEdgeAttributes(_result, context);
        return _result;
    }

    private void _init_globalEdgeAttributes(HashMap<String, ID> it, Graph.Builder context) {
    }

    private Graph transformDotGraph(DotGraph it) {
        Procedures.Procedure2 _function_2;
        boolean _tripleNotEquals;
        Graph _xblockexpression = null;
        this._createCache_globalGraphAttributes.clear();
        this._createCache_globalNodeAttributes.clear();
        this._createCache_globalEdgeAttributes.clear();
        this._createCache_createNode.clear();
        this._createCache_createSubgraph.clear();
        Graph.Builder graphBuilder = new Graph.Builder();
        ID _name = it.getName();
        boolean bl = _tripleNotEquals = _name != null;
        if (_tripleNotEquals) {
            graphBuilder.attr("_name", (Object)it.getName());
        }
        graphBuilder.attr("_type", (Object)it.getType());
        Functions.Function1 _function = it_1 -> !(it_1 instanceof Attribute);
        Consumer<Stmt> _function_1 = it_1 -> this.transformStmt((Stmt)it_1, graphBuilder);
        IterableExtensions.filter(it.getStmts(), (Functions.Function1)_function).forEach(_function_1);
        Graph graph = graphBuilder.build();
        Procedures.Procedure2 setter = _function_2 = (attributeName, f) -> {
            ID attributeValue = DotAstHelper.getAttributeValue(it, attributeName);
            if (attributeValue != null) {
                f.apply((Object)graph, (Object)attributeValue);
            } else {
                boolean _containsKey = this.globalGraphAttributes(graphBuilder).containsKey(attributeName);
                if (_containsKey) {
                    f.apply((Object)graph, (Object)this.globalGraphAttributes(graphBuilder).get(attributeName));
                }
            }
        };
        Procedures.Procedure2 _function_3 = (g, value) -> DotAttributes.setBbRaw(g, value);
        setter.apply((Object)"bb", (Object)_function_3);
        Procedures.Procedure2 _function_4 = (g, value) -> DotAttributes.setBgcolorRaw(g, value);
        setter.apply((Object)"bgcolor", (Object)_function_4);
        Procedures.Procedure2 _function_5 = (g, value) -> DotAttributes.setClusterrankRaw(g, value);
        setter.apply((Object)"clusterrank", (Object)_function_5);
        Procedures.Procedure2 _function_6 = (g, value) -> DotAttributes.setColorschemeRaw(g, value);
        setter.apply((Object)"colorscheme", (Object)_function_6);
        Procedures.Procedure2 _function_7 = (g, value) -> DotAttributes.setFontcolorRaw(g, value);
        setter.apply((Object)"fontcolor", (Object)_function_7);
        Procedures.Procedure2 _function_8 = (g, value) -> DotAttributes.setFontnameRaw(g, value);
        setter.apply((Object)"fontname", (Object)_function_8);
        Procedures.Procedure2 _function_9 = (g, value) -> DotAttributes.setFontsizeRaw(g, value);
        setter.apply((Object)"fontsize", (Object)_function_9);
        Procedures.Procedure2 _function_10 = (g, value) -> DotAttributes.setLabelRaw(g, value);
        setter.apply((Object)"label", (Object)_function_10);
        Procedures.Procedure2 _function_11 = (g, value) -> DotAttributes.setLayoutRaw(g, value);
        setter.apply((Object)"layout", (Object)_function_11);
        Procedures.Procedure2 _function_12 = (g, value) -> DotAttributes.setOutputorderRaw(g, value);
        setter.apply((Object)"outputorder", (Object)_function_12);
        Procedures.Procedure2 _function_13 = (g, value) -> DotAttributes.setPagedirRaw(g, value);
        setter.apply((Object)"pagedir", (Object)_function_13);
        Procedures.Procedure2 _function_14 = (g, value) -> DotAttributes.setRankdirRaw(g, value);
        setter.apply((Object)"rankdir", (Object)_function_14);
        Procedures.Procedure2 _function_15 = (g, value) -> DotAttributes.setSplinesRaw(g, value);
        setter.apply((Object)"splines", (Object)_function_15);
        _xblockexpression = graph;
        return _xblockexpression;
    }

    private Node transformNodeId(NodeId it, Graph.Builder graphBuilder) {
        AttrList _createAttrList = DotFactory.eINSTANCE.createAttrList();
        return this.transformNodeId(it, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new AttrList[]{_createAttrList})), graphBuilder);
    }

    private Node transformNodeId(NodeId it, List<AttrList> attrLists, Graph.Builder graphBuilder) {
        Procedures.Procedure2 _function;
        Node _xblockexpression = null;
        boolean isExistingNode = this._createCache_createNode.containsKey(CollectionLiterals.newArrayList((Object[])new String[]{it.getName().toValue()}));
        Node node = this.createNode(it.getName().toValue());
        if (!isExistingNode) {
            DotAttributes._setNameRaw(node, it.getName());
            graphBuilder.nodes(new Node[]{node});
        }
        Procedures.Procedure2 setter = _function = (attributeName, f) -> {
            ID attributeValue = DotAstHelper.getAttributeValue(attrLists, attributeName);
            if (attributeValue != null) {
                f.apply((Object)node, (Object)attributeValue);
            } else if (!isExistingNode && this.globalNodeAttributes(graphBuilder).containsKey(attributeName)) {
                f.apply((Object)node, (Object)this.globalNodeAttributes(graphBuilder).get(attributeName));
            }
        };
        Procedures.Procedure2 _function_1 = (n, value) -> DotAttributes.setColorRaw(n, value);
        setter.apply((Object)"color", (Object)_function_1);
        Procedures.Procedure2 _function_2 = (n, value) -> DotAttributes.setColorschemeRaw(n, value);
        setter.apply((Object)"colorscheme", (Object)_function_2);
        Procedures.Procedure2 _function_3 = (n, value) -> DotAttributes.setDistortionRaw(n, value);
        setter.apply((Object)"distortion", (Object)_function_3);
        Procedures.Procedure2 _function_4 = (n, value) -> DotAttributes.setFillcolorRaw(n, value);
        setter.apply((Object)"fillcolor", (Object)_function_4);
        Procedures.Procedure2 _function_5 = (n, value) -> DotAttributes.setFixedsizeRaw(n, value);
        setter.apply((Object)"fixedsize", (Object)_function_5);
        Procedures.Procedure2 _function_6 = (n, value) -> DotAttributes.setFontcolorRaw(n, value);
        setter.apply((Object)"fontcolor", (Object)_function_6);
        Procedures.Procedure2 _function_7 = (n, value) -> DotAttributes.setFontnameRaw(n, value);
        setter.apply((Object)"fontname", (Object)_function_7);
        Procedures.Procedure2 _function_8 = (n, value) -> DotAttributes.setFontsizeRaw(n, value);
        setter.apply((Object)"fontsize", (Object)_function_8);
        Procedures.Procedure2 _function_9 = (n, value) -> DotAttributes.setHeightRaw(n, value);
        setter.apply((Object)"height", (Object)_function_9);
        Procedures.Procedure2 _function_10 = (n, value) -> DotAttributes.setIdRaw(n, value);
        setter.apply((Object)"id", (Object)_function_10);
        Procedures.Procedure2 _function_11 = (n, value) -> DotAttributes.setLabelRaw(n, value);
        setter.apply((Object)"label", (Object)_function_11);
        Procedures.Procedure2 _function_12 = (g, value) -> DotAttributes.setPenwidthRaw(g, value);
        setter.apply((Object)"penwidth", (Object)_function_12);
        Procedures.Procedure2 _function_13 = (n, value) -> DotAttributes.setPosRaw(n, value);
        setter.apply((Object)"pos", (Object)_function_13);
        Procedures.Procedure2 _function_14 = (n, value) -> DotAttributes.setShapeRaw(n, value);
        setter.apply((Object)"shape", (Object)_function_14);
        Procedures.Procedure2 _function_15 = (n, value) -> DotAttributes.setSidesRaw(n, value);
        setter.apply((Object)"sides", (Object)_function_15);
        Procedures.Procedure2 _function_16 = (n, value) -> DotAttributes.setSkewRaw(n, value);
        setter.apply((Object)"skew", (Object)_function_16);
        Procedures.Procedure2 _function_17 = (n, value) -> DotAttributes.setStyleRaw(n, value);
        setter.apply((Object)"style", (Object)_function_17);
        Procedures.Procedure2 _function_18 = (n, value) -> DotAttributes.setTooltipRaw(n, value);
        setter.apply((Object)"tooltip", (Object)_function_18);
        Procedures.Procedure2 _function_19 = (n, value) -> DotAttributes.setWidthRaw(n, value);
        setter.apply((Object)"width", (Object)_function_19);
        Procedures.Procedure2 _function_20 = (n, value) -> DotAttributes.setXlabelRaw(n, value);
        setter.apply((Object)"xlabel", (Object)_function_20);
        Procedures.Procedure2 _function_21 = (n, value) -> DotAttributes.setXlpRaw(n, value);
        setter.apply((Object)"xlp", (Object)_function_21);
        _xblockexpression = node;
        return _xblockexpression;
    }

    private void _transformStmt(Stmt it, Graph.Builder graphBuilder) {
        System.err.println("DotImport cannot transform Stmt: " + it);
    }

    private void _transformStmt(AttrStmt it, Graph.Builder graphBuilder) {
        AttributeType _type = it.getType();
        if (_type != null) {
            switch (_type) {
                case GRAPH: {
                    Consumer<AttrList> _function = it_1 -> {
                        Consumer<Attribute> _function_1 = it_2 -> this.globalGraphAttributes(graphBuilder).put(it_2.getName().toValue(), it_2.getValue());
                        it_1.getAttributes().forEach(_function_1);
                    };
                    it.getAttrLists().forEach(_function);
                    break;
                }
                case NODE: {
                    Consumer<AttrList> _function_1 = it_1 -> {
                        Consumer<Attribute> _function_2 = it_2 -> this.globalNodeAttributes(graphBuilder).put(it_2.getName().toValue(), it_2.getValue());
                        it_1.getAttributes().forEach(_function_2);
                    };
                    it.getAttrLists().forEach(_function_1);
                    break;
                }
                case EDGE: {
                    Consumer<AttrList> _function_2 = it_1 -> {
                        Consumer<Attribute> _function_3 = it_2 -> this.globalEdgeAttributes(graphBuilder).put(it_2.getName().toValue(), it_2.getValue());
                        it_1.getAttributes().forEach(_function_3);
                    };
                    it.getAttrLists().forEach(_function_2);
                    break;
                }
            }
        }
    }

    private void _transformStmt(NodeStmt it, Graph.Builder graphBuilder) {
        this.transformNodeId(it.getNode(), (List<AttrList>)it.getAttrLists(), graphBuilder);
    }

    private void _transformStmt(EdgeStmtNode it, Graph.Builder graphBuilder) {
        Node sourceNode = this.transformNodeId(it.getNode(), graphBuilder);
        EList<EdgeRhs> _edgeRHS = it.getEdgeRHS();
        for (EdgeRhs edgeRhs : _edgeRHS) {
            boolean _matched = false;
            if (edgeRhs instanceof EdgeRhsNode) {
                _matched = true;
                Node targetNode = this.transformNodeId(((EdgeRhsNode)edgeRhs).getNode(), graphBuilder);
                graphBuilder.edges(new Edge[]{this.createEdge(sourceNode, ((EdgeRhsNode)edgeRhs).getOp().getLiteral(), targetNode, (List<AttrList>)it.getAttrLists(), graphBuilder)});
                sourceNode = targetNode;
            }
            if (_matched) continue;
            System.err.println("DotImport cannot transform EdgeStmtNode: " + it);
        }
    }

    private void _transformStmt(Subgraph it, Graph.Builder graphBuilder) {
        Procedures.Procedure2 _function_4;
        boolean _tripleNotEquals;
        boolean isExistingSubgraph = it.getName() != null && this._createCache_createSubgraph.containsKey(CollectionLiterals.newArrayList((Object[])new String[]{it.getName().toValue()}));
        Graph.Builder subgraphBuilder = new Graph.Builder();
        Node _xifexpression = null;
        ID _name = it.getName();
        boolean _tripleEquals = _name == null;
        _xifexpression = _tripleEquals ? this.createSubgraph(Integer.valueOf(System.identityHashCode(subgraphBuilder)).toString()) : this.createSubgraph(it.getName().toValue());
        Node subgraphNode = _xifexpression;
        ID _name_1 = it.getName();
        boolean bl = _tripleNotEquals = _name_1 != null;
        if (_tripleNotEquals) {
            subgraphBuilder.attr("_name", (Object)it.getName());
        }
        this.globalGraphAttributes(subgraphBuilder).putAll(this.globalGraphAttributes(graphBuilder));
        this.globalNodeAttributes(subgraphBuilder).putAll(this.globalNodeAttributes(graphBuilder));
        this.globalEdgeAttributes(subgraphBuilder).putAll(this.globalEdgeAttributes(graphBuilder));
        Functions.Function1 _function = it_1 -> !(it_1 instanceof Attribute);
        Consumer<Stmt> _function_1 = it_1 -> this.transformStmt((Stmt)it_1, subgraphBuilder);
        IterableExtensions.filter(it.getStmts(), (Functions.Function1)_function).forEach(_function_1);
        Graph subgraph = subgraphBuilder.build();
        if (!isExistingSubgraph) {
            subgraphNode.setNestedGraph(subgraph);
            subgraph.setNestingNode(subgraphNode);
            graphBuilder.nodes(new Node[]{subgraphNode});
        } else {
            subgraphNode.getNestedGraph().getAttributes().putAll((Map)subgraph.getAttributes());
            Functions.Function1 _function_2 = it_1 -> {
                boolean _contains = subgraphNode.getNestedGraph().getNodes().contains(it_1);
                return !_contains;
            };
            Iterables.addAll((Collection)subgraphNode.getNestedGraph().getNodes(), (Iterable)IterableExtensions.filter((Iterable)subgraph.getNodes(), (Functions.Function1)_function_2));
            Functions.Function1 _function_3 = it_1 -> {
                boolean _contains = subgraphNode.getNestedGraph().getNodes().contains(it_1);
                return !_contains;
            };
            Iterables.addAll((Collection)subgraphNode.getNestedGraph().getEdges(), (Iterable)IterableExtensions.filter((Iterable)subgraph.getEdges(), (Functions.Function1)_function_3));
        }
        Procedures.Procedure2 setter = _function_4 = (attributeName, f) -> {
            ID attributeValue = DotAstHelper.getAttributeValue(it, attributeName);
            if (attributeValue != null) {
                f.apply((Object)subgraph, (Object)attributeValue);
            } else {
                boolean _containsKey = this.globalGraphAttributes(subgraphBuilder).containsKey(attributeName);
                if (_containsKey) {
                    f.apply((Object)subgraph, (Object)this.globalGraphAttributes(subgraphBuilder).get(attributeName));
                }
            }
        };
        Procedures.Procedure2 _function_5 = (g, value) -> DotAttributes.setBbRaw(g, value);
        setter.apply((Object)"bb", (Object)_function_5);
        Procedures.Procedure2 _function_6 = (g, value) -> DotAttributes.setBgcolorRaw(g, value);
        setter.apply((Object)"bgcolor", (Object)_function_6);
        Procedures.Procedure2 _function_7 = (g, value) -> DotAttributes.setColorRaw(g, value);
        setter.apply((Object)"color", (Object)_function_7);
        Procedures.Procedure2 _function_8 = (g, value) -> DotAttributes.setColorschemeRaw(g, value);
        setter.apply((Object)"colorscheme", (Object)_function_8);
        Procedures.Procedure2 _function_9 = (g, value) -> DotAttributes.setFillcolorRaw(g, value);
        setter.apply((Object)"fillcolor", (Object)_function_9);
        Procedures.Procedure2 _function_10 = (g, value) -> DotAttributes.setFontcolorRaw(g, value);
        setter.apply((Object)"fontcolor", (Object)_function_10);
        Procedures.Procedure2 _function_11 = (g, value) -> DotAttributes.setFontnameRaw(g, value);
        setter.apply((Object)"fontname", (Object)_function_11);
        Procedures.Procedure2 _function_12 = (g, value) -> DotAttributes.setFontsizeRaw(g, value);
        setter.apply((Object)"fontsize", (Object)_function_12);
        Procedures.Procedure2 _function_13 = (g, value) -> DotAttributes.setIdRaw(g, value);
        setter.apply((Object)"id", (Object)_function_13);
        Procedures.Procedure2 _function_14 = (g, value) -> DotAttributes.setLabelRaw(g, value);
        setter.apply((Object)"label", (Object)_function_14);
        Procedures.Procedure2 _function_15 = (g, value) -> DotAttributes.setLpRaw(g, value);
        setter.apply((Object)"lp", (Object)_function_15);
        Procedures.Procedure2 _function_16 = (g, value) -> DotAttributes.setRankRaw(g, value);
        setter.apply((Object)"rank", (Object)_function_16);
        Procedures.Procedure2 _function_17 = (g, value) -> DotAttributes.setPenwidthRaw(g, value);
        setter.apply((Object)"penwidth", (Object)_function_17);
        Procedures.Procedure2 _function_18 = (g, value) -> DotAttributes.setStyleRaw(g, value);
        setter.apply((Object)"style", (Object)_function_18);
        Procedures.Procedure2 _function_19 = (g, value) -> DotAttributes.setTooltipRaw(g, value);
        setter.apply((Object)"tooltip", (Object)_function_19);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createSubgraph(String subgraphName) {
        Node _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new String[]{subgraphName});
        HashMap<ArrayList<?>, Node> hashMap = this._createCache_createSubgraph;
        synchronized (hashMap) {
            Node _buildNode;
            if (this._createCache_createSubgraph.containsKey(_cacheKey)) {
                return this._createCache_createSubgraph.get(_cacheKey);
            }
            _result = _buildNode = new Node.Builder().buildNode();
            this._createCache_createSubgraph.put(_cacheKey, _result);
        }
        this._init_createSubgraph(_result, subgraphName);
        return _result;
    }

    private void _init_createSubgraph(Node it, String subgraphName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createNode(String nodeName) {
        Node _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new String[]{nodeName});
        HashMap<ArrayList<?>, Node> hashMap = this._createCache_createNode;
        synchronized (hashMap) {
            Node _buildNode;
            if (this._createCache_createNode.containsKey(_cacheKey)) {
                return this._createCache_createNode.get(_cacheKey);
            }
            _result = _buildNode = new Node.Builder().buildNode();
            this._createCache_createNode.put(_cacheKey, _result);
        }
        this._init_createNode(_result, nodeName);
        return _result;
    }

    private void _init_createNode(Node it, String nodeName) {
    }

    private Edge createEdge(Node sourceNode, String edgeOp, Node targetNode, List<AttrList> attrLists, Graph.Builder graphBuilder) {
        Procedures.Procedure2 _function;
        Edge _xblockexpression = null;
        Edge edge = new Edge.Builder(sourceNode, targetNode).buildEdge();
        Procedures.Procedure2 setter = _function = (attributeName, f) -> {
            ID attributeValue = DotAstHelper.getAttributeValue(attrLists, attributeName);
            if (attributeValue != null) {
                f.apply((Object)edge, (Object)attributeValue);
            } else {
                boolean _containsKey = this.globalEdgeAttributes(graphBuilder).containsKey(attributeName);
                if (_containsKey) {
                    f.apply((Object)edge, (Object)this.globalEdgeAttributes(graphBuilder).get(attributeName));
                }
            }
        };
        Procedures.Procedure2 _function_1 = (e, value) -> DotAttributes.setArrowheadRaw(e, value);
        setter.apply((Object)"arrowhead", (Object)_function_1);
        Procedures.Procedure2 _function_2 = (e, value) -> DotAttributes.setArrowsizeRaw(e, value);
        setter.apply((Object)"arrowsize", (Object)_function_2);
        Procedures.Procedure2 _function_3 = (e, value) -> DotAttributes.setArrowtailRaw(e, value);
        setter.apply((Object)"arrowtail", (Object)_function_3);
        Procedures.Procedure2 _function_4 = (e, value) -> DotAttributes.setColorRaw(e, value);
        setter.apply((Object)"color", (Object)_function_4);
        Procedures.Procedure2 _function_5 = (e, value) -> DotAttributes.setColorschemeRaw(e, value);
        setter.apply((Object)"colorscheme", (Object)_function_5);
        Procedures.Procedure2 _function_6 = (e, value) -> DotAttributes.setDirRaw(e, value);
        setter.apply((Object)"dir", (Object)_function_6);
        Procedures.Procedure2 _function_7 = (e, value) -> DotAttributes.setEdgetooltipRaw(e, value);
        setter.apply((Object)"edgetooltip", (Object)_function_7);
        Procedures.Procedure2 _function_8 = (e, value) -> DotAttributes.setFillcolorRaw(e, value);
        setter.apply((Object)"fillcolor", (Object)_function_8);
        Procedures.Procedure2 _function_9 = (e, value) -> DotAttributes.setFontcolorRaw(e, value);
        setter.apply((Object)"fontcolor", (Object)_function_9);
        Procedures.Procedure2 _function_10 = (e, value) -> DotAttributes.setFontnameRaw(e, value);
        setter.apply((Object)"fontname", (Object)_function_10);
        Procedures.Procedure2 _function_11 = (e, value) -> DotAttributes.setFontsizeRaw(e, value);
        setter.apply((Object)"fontsize", (Object)_function_11);
        Procedures.Procedure2 _function_12 = (e, value) -> DotAttributes.setHeadLpRaw(e, value);
        setter.apply((Object)"head_lp", (Object)_function_12);
        Procedures.Procedure2 _function_13 = (e, value) -> DotAttributes.setHeadlabelRaw(e, value);
        setter.apply((Object)"headlabel", (Object)_function_13);
        Procedures.Procedure2 _function_14 = (e, value) -> DotAttributes.setHeadportRaw(e, value);
        setter.apply((Object)"headport", (Object)_function_14);
        Procedures.Procedure2 _function_15 = (e, value) -> DotAttributes.setHeadtooltipRaw(e, value);
        setter.apply((Object)"headtooltip", (Object)_function_15);
        Procedures.Procedure2 _function_16 = (e, value) -> DotAttributes.setIdRaw(e, value);
        setter.apply((Object)"id", (Object)_function_16);
        Procedures.Procedure2 _function_17 = (e, value) -> DotAttributes.setLabelRaw(e, value);
        setter.apply((Object)"label", (Object)_function_17);
        Procedures.Procedure2 _function_18 = (e, value) -> DotAttributes.setLabelfontcolorRaw(e, value);
        setter.apply((Object)"labelfontcolor", (Object)_function_18);
        Procedures.Procedure2 _function_19 = (e, value) -> DotAttributes.setLabelfontnameRaw(e, value);
        setter.apply((Object)"labelfontname", (Object)_function_19);
        Procedures.Procedure2 _function_20 = (e, value) -> DotAttributes.setLabelfontsizeRaw(e, value);
        setter.apply((Object)"labelfontsize", (Object)_function_20);
        Procedures.Procedure2 _function_21 = (e, value) -> DotAttributes.setLabeltooltipRaw(e, value);
        setter.apply((Object)"labeltooltip", (Object)_function_21);
        Procedures.Procedure2 _function_22 = (e, value) -> DotAttributes.setLpRaw(e, value);
        setter.apply((Object)"lp", (Object)_function_22);
        Procedures.Procedure2 _function_23 = (g, value) -> DotAttributes.setPenwidthRaw(g, value);
        setter.apply((Object)"penwidth", (Object)_function_23);
        Procedures.Procedure2 _function_24 = (e, value) -> DotAttributes.setPosRaw(e, value);
        setter.apply((Object)"pos", (Object)_function_24);
        Procedures.Procedure2 _function_25 = (e, value) -> DotAttributes.setStyleRaw(e, value);
        setter.apply((Object)"style", (Object)_function_25);
        Procedures.Procedure2 _function_26 = (e, value) -> DotAttributes.setTaillabelRaw(e, value);
        setter.apply((Object)"taillabel", (Object)_function_26);
        Procedures.Procedure2 _function_27 = (e, value) -> DotAttributes.setTailportRaw(e, value);
        setter.apply((Object)"tailport", (Object)_function_27);
        Procedures.Procedure2 _function_28 = (e, value) -> DotAttributes.setTailtooltipRaw(e, value);
        setter.apply((Object)"tailtooltip", (Object)_function_28);
        Procedures.Procedure2 _function_29 = (e, value) -> DotAttributes.setTailLpRaw(e, value);
        setter.apply((Object)"tail_lp", (Object)_function_29);
        Procedures.Procedure2 _function_30 = (e, value) -> DotAttributes.setTooltipRaw(e, value);
        setter.apply((Object)"tooltip", (Object)_function_30);
        Procedures.Procedure2 _function_31 = (e, value) -> DotAttributes.setXlabelRaw(e, value);
        setter.apply((Object)"xlabel", (Object)_function_31);
        Procedures.Procedure2 _function_32 = (e, value) -> DotAttributes.setXlpRaw(e, value);
        setter.apply((Object)"xlp", (Object)_function_32);
        _xblockexpression = edge;
        return _xblockexpression;
    }

    private void transformStmt(Stmt it, Graph.Builder graphBuilder) {
        if (it instanceof Subgraph) {
            this._transformStmt((Subgraph)it, graphBuilder);
            return;
        }
        if (it instanceof AttrStmt) {
            this._transformStmt((AttrStmt)it, graphBuilder);
            return;
        }
        if (it instanceof EdgeStmtNode) {
            this._transformStmt((EdgeStmtNode)it, graphBuilder);
            return;
        }
        if (it instanceof NodeStmt) {
            this._transformStmt((NodeStmt)it, graphBuilder);
            return;
        }
        if (it != null) {
            this._transformStmt(it, graphBuilder);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, graphBuilder).toString());
    }
}

