/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public class SSLProperties {
    public static final String PROTOCOL = "org.eclipse.net4j.tcp.ssl.protocol";
    public static final String KEY_PATH = "org.eclipse.net4j.tcp.ssl.key";
    public static final String TRUST_PATH = "org.eclipse.net4j.tcp.ssl.trust";
    public static final String PASS_PHRASE = "org.eclipse.net4j.tcp.ssl.passphrase";
    public static final String HANDSHAKE_TIMEOUT = "org.eclipse.net4j.tcp.ssl.handshake.timeout";
    public static final String HANDSHAKE_WAITTIME = "org.eclipse.net4j.tcp.ssl.handshake.waittime";
    public static final String CHECK_VALIDITY_CERTIFICATE = "check.validity.certificate";
    private Properties localProperties;

    public SSLProperties(String localConfigUrl) throws IOException {
        if (!StringUtil.isEmpty((String)localConfigUrl)) {
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (InputStream in = new URL(localConfigUrl).openStream();){
                    this.localProperties = new Properties();
                    this.localProperties.load(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IOException("SSL config cannot be loaded", ex);
            }
        }
    }

    public String getProtocol(String defaultValue) {
        return this.getValue(PROTOCOL, defaultValue);
    }

    public String getKeyPath(String defaultValue) {
        return this.getValue(KEY_PATH, defaultValue);
    }

    public String getTrustPath(String defaultValue) {
        return this.getValue(TRUST_PATH, defaultValue);
    }

    public String getPassPhrase(String defaultValue) {
        return this.getValue(PASS_PHRASE, defaultValue);
    }

    public int getHandShakeTimeOut(int defaultValue) {
        return this.getValue(HANDSHAKE_TIMEOUT, defaultValue);
    }

    public int getHandShakeWaitTime(int defaultValue) {
        return this.getValue(HANDSHAKE_WAITTIME, defaultValue);
    }

    private String getValue(String key, String defaultValue) {
        String value = OMPlatform.INSTANCE.getProperty(key);
        if (StringUtil.isEmpty((String)value) && this.localProperties != null) {
            value = this.localProperties.getProperty(key);
        }
        if (StringUtil.isEmpty((String)value)) {
            return defaultValue;
        }
        return value;
    }

    private int getValue(String key, int defaultValue) {
        String value = OMPlatform.INSTANCE.getProperty(key);
        if (StringUtil.isEmpty((String)value) && this.localProperties != null) {
            value = this.localProperties.getProperty(key);
        }
        if (StringUtil.isEmpty((String)value)) {
            return defaultValue;
        }
        if (value != null) {
            return Integer.parseInt(value);
        }
        return 0;
    }
}

