/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.junit4.ui.util;

import java.text.MessageFormat;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.junit.Assert;

public class ImageTester {
    private ImageTester() {
    }

    public static void assertImageIs(Image expectedImage, Image actualImage) {
        ImageTester.assertImageDataIs(expectedImage.getImageData(), actualImage.getImageData());
    }

    public static void assertImageDataIs(ImageData expectedImageData, ImageData actualImageData) {
        if (expectedImageData.width != actualImageData.width || expectedImageData.height != actualImageData.height) {
            Assert.fail((String)MessageFormat.format("Image data do not have the same dimensions ({0}x{1} expected, got {2}x{3})", expectedImageData.width, expectedImageData.height, actualImageData.width, actualImageData.height));
        }
        int y = 0;
        while (y < expectedImageData.height) {
            int x = 0;
            while (x < expectedImageData.width) {
                RGB expectedRGB;
                int actualPixel = actualImageData.getPixel(x, y);
                int expectedPixel = expectedImageData.getPixel(x, y);
                RGB actualRGB = actualImageData.palette.getRGB(actualPixel);
                if (!actualRGB.equals((Object)(expectedRGB = expectedImageData.palette.getRGB(expectedPixel)))) {
                    Assert.fail((String)MessageFormat.format("Image data do not match at ({0},{1})", x, y));
                }
                ++x;
            }
            ++y;
        }
    }
}

